/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.network;

import com.goodbird.player2npc.Player2NPC;
import com.goodbird.player2npc.companion.AutomatoneEntity;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.CharacterUtils;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class AutomatonSpawnPacket {
    private final int id;
    private final UUID uuid;
    private final class_243 pos;
    private final class_243 velocity;
    private final float pitch;
    private final float yaw;
    private final Character character;
    private final LivingEntityInventory inventory;

    private AutomatonSpawnPacket(AutomatoneEntity entity) {
        this.id = entity.method_5628();
        this.uuid = entity.method_5667();
        this.pos = entity.method_19538();
        this.velocity = entity.method_18798();
        this.pitch = entity.method_36455();
        this.yaw = entity.method_36454();
        this.character = entity.getCharacter();
        this.inventory = entity.inventory;
    }

    public AutomatonSpawnPacket(class_9129 buf) {
        this.id = buf.method_10816();
        this.uuid = buf.method_10790();
        this.pos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.velocity = new class_243((double)buf.readShort(), (double)buf.readShort(), (double)buf.readShort());
        this.pitch = (float)(buf.readByte() * 360) / 256.0f;
        this.yaw = (float)(buf.readByte() * 360) / 256.0f;
        this.character = CharacterUtils.readFromBuf((class_2540)buf);
        this.inventory = new LivingEntityInventory((class_1309)null);
        this.inventory.readNbt((class_7225.class_7874)buf.method_56349(), buf.method_10798().method_10554("inv", 10));
    }

    public static class_2596<class_2602> create(class_5455 access, AutomatoneEntity entity) {
        class_9129 buf = new class_9129(Unpooled.buffer(), access);
        new AutomatonSpawnPacket(entity).write(access, (class_2540)buf);
        return NetworkManager.toPacket((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)Player2NPC.SPAWN_PACKET_ID, (class_9129)buf);
    }

    public void write(class_5455 access, class_2540 buf) {
        buf.method_10804(this.id);
        buf.method_10797(this.uuid);
        buf.method_52940(this.pos.field_1352);
        buf.method_52940(this.pos.field_1351);
        buf.method_52940(this.pos.field_1350);
        buf.method_52998((int)(Math.min(3.9, this.velocity.field_1352) * 8000.0));
        buf.method_52998((int)(Math.min(3.9, this.velocity.field_1351) * 8000.0));
        buf.method_52998((int)(Math.min(3.9, this.velocity.field_1350) * 8000.0));
        buf.method_52997((int)((byte)(this.pitch * 256.0f / 360.0f)));
        buf.method_52997((int)((byte)(this.yaw * 256.0f / 360.0f)));
        CharacterUtils.writeToBuf((class_2540)buf, (Character)this.character);
        class_2487 compound = new class_2487();
        compound.method_10566("inv", (class_2520)this.inventory.writeNbt((class_7225.class_7874)access, new class_2499()));
        buf.method_10794((class_2520)compound);
    }

    public static void handle(class_9129 var3, NetworkManager.PacketContext var4) {
        AutomatonSpawnPacket packet = new AutomatonSpawnPacket(var3);
        var4.queue(() -> {
            class_638 world = (class_638)var4.getPlayer().method_37908();
            AutomatoneEntity entity = new AutomatoneEntity((class_1299<? extends AutomatoneEntity>)((class_1299)Player2NPC.AUTOMATONE.get()), (class_1937)world);
            entity.method_5838(packet.id);
            entity.method_5826(packet.uuid);
            entity.method_43391(packet.pos.field_1352, packet.pos.field_1351, packet.pos.field_1350);
            entity.method_24203(packet.pos.field_1352, packet.pos.field_1351, packet.pos.field_1350);
            entity.method_18799(packet.velocity);
            entity.method_36457(packet.pitch);
            entity.method_36456(packet.yaw);
            entity.setCharacter(packet.character);
            packet.inventory.player = entity;
            entity.inventory = packet.inventory;
            world.method_53875((class_1297)entity);
        });
    }
}

