/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.client.gui;

import com.goodbird.player2npc.client.gui.CharacterCardWidget;
import com.goodbird.player2npc.client.gui.CharacterDetailScreen;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.CharacterUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class CharacterSelectionScreen
extends class_437 {
    private Character[] characters = null;
    private boolean isLoading = true;

    public CharacterSelectionScreen() {
        super(class_2561.method_30163((String)"Select a Character"));
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.isLoading = true;
        CompletableFuture.supplyAsync(() -> CharacterUtils.requestCharacters((class_1657)class_310.method_1551().field_1724, (String)"player2-ai-npc-minecraft")).thenAcceptAsync(result -> {
            this.characters = result;
            this.isLoading = false;
            this.field_22787.execute(this::createCharacterCards);
        }, (Executor)this.field_22787);
    }

    private void createCharacterCards() {
        if (this.characters != null && this.characters.length != 0) {
            int cardWidth = 100;
            int cardHeight = 130;
            int padding = 30;
            int cardsPerRow = Math.max(1, (this.field_22789 - padding) / (cardWidth + padding));
            int totalWidth = cardsPerRow * (cardWidth + padding) - padding;
            int startX = this.field_22789 / 2 - totalWidth / 2;
            int startY = 70;
            int currentX = startX;
            int currentY = startY;
            for (Character character : this.characters) {
                this.method_37063((class_364)new CharacterCardWidget(currentX, currentY, cardWidth, cardHeight, character, this::onCharacterClicked));
                if ((currentX += cardWidth + padding) + cardWidth <= startX + totalWidth) continue;
                currentX = startX;
                currentY += cardHeight + padding;
            }
        }
    }

    private void onCharacterClicked(Character character) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new CharacterDetailScreen(this, character));
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics, mouseX, mouseY, delta);
        graphics.method_25300(this.field_22793, "Select a Character", this.field_22789 / 2, 20, 0xFFFFFF);
        if (this.isLoading) {
            graphics.method_25300(this.field_22793, "Loading...", this.field_22789 / 2, this.field_22790 / 2, 0xAAAAAA);
        }
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    public boolean method_25421() {
        return false;
    }
}

