/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.companion;

import com.goodbird.player2npc.companion.AutomatoneEntity;
import com.goodbird.player2npc.mixins.IEntityPersistentData;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.CharacterUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompanionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_3222 _player;
    private final Map<String, UUID> _companionMap = new ConcurrentHashMap<String, UUID>();
    private final Map<String, class_2487> _despawnedCompanionData = new ConcurrentHashMap<String, class_2487>();
    private List<Character> _assignedCharacters = new ArrayList<Character>();
    private boolean _needsToSummon = false;
    private static final Map<String, CompanionManager> cache = new HashMap<String, CompanionManager>();

    public CompanionManager(class_3222 player) {
        this._player = player;
    }

    public static CompanionManager get(class_3222 player) {
        return cache.computeIfAbsent(player.method_5477().getString(), name -> {
            CompanionManager manager = new CompanionManager(player);
            manager.readFromNbt();
            return manager;
        });
    }

    public static void remove(class_3222 player) {
        cache.remove(player.method_5477().getString());
    }

    public void summonAllCompanionsAsync() {
        this._needsToSummon = true;
        CompletableFuture.supplyAsync(() -> CharacterUtils.requestCharacters((class_1657)this._player, (String)"player2-ai-npc-minecraft")).thenAcceptAsync(characters -> {
            this._assignedCharacters = new ArrayList<Character>(Arrays.asList(characters));
        }, (Executor)this._player.method_5682());
    }

    private void summonCompanions() {
        if (!this._assignedCharacters.isEmpty()) {
            List<String> assignedNames = this._assignedCharacters.stream().map(c -> c.name()).toList();
            ArrayList toDismiss = new ArrayList();
            this._companionMap.forEach((name, uuid) -> {
                if (!assignedNames.contains(name)) {
                    toDismiss.add(name);
                }
            });
            toDismiss.forEach(this::dismissCompanion);
            this._assignedCharacters.stream().filter(character -> character != null).forEach(character -> {
                LOGGER.info("summonCompanions for character={}", character);
                this.ensureCompanionExists((Character)character);
            });
            this._assignedCharacters.clear();
            this.writeToNbt();
        }
    }

    public void ensureCompanionExists(Character character) {
        LOGGER.info("ensureCompanionExists for character={}", (Object)character);
        if (this._player.method_37908() != null && this._player.method_5682() != null) {
            LOGGER.info("ensureCompanionExists NOTNULL");
            UUID companionUuid = this._companionMap.get(character.name());
            class_3218 world = this._player.method_51469();
            if (this._despawnedCompanionData.containsKey(character.name())) {
                LOGGER.info("ensureCompanionExists DESPAWNED");
                try {
                    class_2487 savedState = this._despawnedCompanionData.remove(character.name());
                    AutomatoneEntity restoredCompanion = new AutomatoneEntity(this._player.method_37908(), character, (class_1657)this._player);
                    restoredCompanion.method_5749(savedState);
                    class_2338 spawnPos = this._player.method_24515().method_10069(this._player.method_59922().method_43048(3) - 1, 1, this._player.method_59922().method_43048(3) - 1);
                    restoredCompanion.method_5808((double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, this._player.method_36454(), 0.0f);
                    world.method_8649((class_1297)restoredCompanion);
                    this._companionMap.put(character.name(), restoredCompanion.method_5667());
                    PrintStream var10000 = System.out;
                    String var10001 = character.name();
                    LOGGER.info("Restored companion from saved state: " + var10001 + " for player " + this._player.method_5477().getString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.writeToNbt();
            } else {
                class_1297 existingCompanion = companionUuid != null ? world.method_14190(companionUuid) : null;
                class_2338 spawnPos = this._player.method_24515().method_10069(this._player.method_59922().method_43048(3) - 1, 1, this._player.method_59922().method_43048(3) - 1);
                if (existingCompanion instanceof AutomatoneEntity && existingCompanion.method_5805()) {
                    LOGGER.info("ensureCompanionExists TP");
                    existingCompanion.method_24203((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
                    PrintStream var11 = System.out;
                    String var13 = character.name();
                    var11.println("Teleported existing companion: " + var13 + " for player " + this._player.method_5477().getString());
                } else {
                    LOGGER.info("ensureCompanionExists SPAWN");
                    try {
                        AutomatoneEntity newCompanion = new AutomatoneEntity(this._player.method_37908(), character, (class_1657)this._player);
                        newCompanion.method_5808((double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, this._player.method_36454(), 0.0f);
                        world.method_8649((class_1297)newCompanion);
                        this._companionMap.put(character.name(), newCompanion.method_5667());
                        PrintStream var10 = System.out;
                        String var12 = character.name();
                        var10.println("Summoned new companion: " + var12 + " for player " + this._player.method_5477().getString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.writeToNbt();
                }
            }
        }
    }

    public void dismissCompanion(String characterName) {
        UUID companionUuid = this._companionMap.remove(characterName);
        if (companionUuid != null && this._player.method_5682() != null) {
            for (class_3218 world : this._player.method_5682().method_3738()) {
                class_1297 companion = world.method_14190(companionUuid);
                if (!(companion instanceof AutomatoneEntity)) continue;
                AutomatoneEntity automatone = (AutomatoneEntity)companion;
                class_2487 savedState = new class_2487();
                automatone.method_5652(savedState);
                this._despawnedCompanionData.put(characterName, savedState);
                companion.method_31472();
                System.out.println("Dismissed companion: " + characterName + " for player " + this._player.method_5477().getString());
                this.writeToNbt();
                return;
            }
        }
    }

    public void dismissAllCompanions() {
        ArrayList<String> names = new ArrayList<String>(this._companionMap.keySet());
        names.forEach(this::dismissCompanion);
        this._companionMap.clear();
    }

    public List<AutomatoneEntity> getActiveCompanions() {
        ArrayList<AutomatoneEntity> companions = new ArrayList<AutomatoneEntity>();
        if (this._player.method_5682() == null) {
            return companions;
        }
        block0: for (UUID uuid : this._companionMap.values()) {
            for (class_3218 world : this._player.method_5682().method_3738()) {
                AutomatoneEntity companion;
                class_1297 entity = world.method_14190(uuid);
                if (!(entity instanceof AutomatoneEntity) || !(companion = (AutomatoneEntity)entity).method_5805()) continue;
                companions.add(companion);
                continue block0;
            }
        }
        return companions;
    }

    public void serverTick() {
        if (this._needsToSummon && !this._assignedCharacters.isEmpty()) {
            this.summonCompanions();
            this._needsToSummon = false;
        }
    }

    public void readFromNbt() {
        class_2487 tag = ((IEntityPersistentData)this._player).getPersistentData();
        if (tag.method_33133()) {
            return;
        }
        this._companionMap.clear();
        this._despawnedCompanionData.clear();
        class_2487 companionsTag = tag.method_10562("companions");
        for (String key : companionsTag.method_10541()) {
            this._companionMap.put(key, companionsTag.method_25926(key));
        }
        class_2487 despawnedTag = tag.method_10562("despawnedCompanions");
        for (String key : despawnedTag.method_10541()) {
            this._despawnedCompanionData.put(key, despawnedTag.method_10562(key));
        }
    }

    public void writeToNbt() {
        class_2487 tag = ((IEntityPersistentData)this._player).getPersistentData();
        class_2487 companionsTag = new class_2487();
        this._companionMap.forEach((arg_0, arg_1) -> ((class_2487)companionsTag).method_25927(arg_0, arg_1));
        tag.method_10566("companions", (class_2520)companionsTag);
        class_2487 despawnedTag = new class_2487();
        this._despawnedCompanionData.forEach((arg_0, arg_1) -> ((class_2487)despawnedTag).method_10566(arg_0, arg_1));
        tag.method_10566("despawnedCompanions", (class_2520)despawnedTag);
    }
}

