/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc;

import com.goodbird.player2npc.Player2NPC;
import com.goodbird.player2npc.client.gui.CharacterSelectionScreen;
import com.goodbird.player2npc.client.render.RenderAutomaton;
import com.goodbird.player2npc.client.util.ClientPersistence;
import com.goodbird.player2npc.network.AutomatonSpawnPacket;
import com.mojang.blaze3d.platform.InputConstants;
import com.player2.playerengine.PlayerEngineClient;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Player2NPCClient {
    private static KeyMapping openCharacterScreenKeybind;
    private static KeyMapping ttsEnableKeybind;
    private static long lastHeartbeatTime;

    public static void onInitializeClient() {
        EntityRendererRegistry.register(Player2NPC.AUTOMATONE, RenderAutomaton::new);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)Player2NPC.SPAWN_PACKET_ID, AutomatonSpawnPacket::handle);
        openCharacterScreenKeybind = new KeyMapping("key.player2npc.open_character_screen", InputConstants.Type.KEYSYM, 72, "category.player2npc.keys");
        ttsEnableKeybind = new KeyMapping("key.player2npc.tts_toggle", InputConstants.Type.KEYSYM, 79, "category.player2npc.keys");
        KeyMappingRegistry.register((KeyMapping)openCharacterScreenKeybind);
        KeyMappingRegistry.register((KeyMapping)ttsEnableKeybind);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> {
            if (!ClientPersistence.getTTStatus()) {
                player.m_213846_((Component)Component.m_237113_((String)"Welcome to Player2NPC!"));
                player.m_213846_((Component)Component.m_237113_((String)"To spawn a companion, press H. (Make sure you have at least one selected characeter at player2.game)"));
                player.m_213846_((Component)Component.m_237113_((String)"To toggle text to speech (TTS), press O."));
                ClientPersistence.saveTTSStatus(true);
            }
        });
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (openCharacterScreenKeybind.m_90859_() && client.f_91073_ != null) {
                client.m_91152_((Screen)new CharacterSelectionScreen());
            }
            if (ttsEnableKeybind.m_90859_()) {
                PlayerEngineClient.enabledTTS = !PlayerEngineClient.enabledTTS;
                client.f_91074_.m_213846_((Component)Component.m_237113_((String)(PlayerEngineClient.enabledTTS ? "Enabled TTS" : "Disabled TTS")));
            }
        });
    }

    static {
        lastHeartbeatTime = System.nanoTime();
    }
}

