/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.network;

import com.goodbird.player2npc.Player2NPC;
import com.goodbird.player2npc.companion.AutomatoneEntity;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.CharacterUtils;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AutomatonSpawnPacket {
    private final int id;
    private final UUID uuid;
    private final Vec3 pos;
    private final Vec3 velocity;
    private final float pitch;
    private final float yaw;
    private final Character character;
    private final LivingEntityInventory inventory;

    private AutomatonSpawnPacket(AutomatoneEntity entity) {
        this.id = entity.m_19879_();
        this.uuid = entity.m_20148_();
        this.pos = entity.m_20182_();
        this.velocity = entity.m_20184_();
        this.pitch = entity.m_146909_();
        this.yaw = entity.m_146908_();
        this.character = entity.getCharacter();
        this.inventory = entity.inventory;
    }

    public AutomatonSpawnPacket(FriendlyByteBuf buf) {
        this.id = buf.m_130242_();
        this.uuid = buf.m_130259_();
        this.pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.velocity = new Vec3((double)buf.readShort(), (double)buf.readShort(), (double)buf.readShort());
        this.pitch = (float)(buf.readByte() * 360) / 256.0f;
        this.yaw = (float)(buf.readByte() * 360) / 256.0f;
        this.character = CharacterUtils.readFromBuf((FriendlyByteBuf)buf);
        this.inventory = new LivingEntityInventory((LivingEntity)null);
        this.inventory.readNbt(buf.m_130260_().m_128437_("inv", 10));
    }

    public static Packet<ClientGamePacketListener> create(AutomatoneEntity entity) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        new AutomatonSpawnPacket(entity).write(buf);
        return NetworkManager.toPacket((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)Player2NPC.SPAWN_PACKET_ID, (FriendlyByteBuf)buf);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.id);
        buf.m_130077_(this.uuid);
        buf.writeDouble(this.pos.f_82479_);
        buf.writeDouble(this.pos.f_82480_);
        buf.writeDouble(this.pos.f_82481_);
        buf.writeShort((int)(Math.min(3.9, this.velocity.f_82479_) * 8000.0));
        buf.writeShort((int)(Math.min(3.9, this.velocity.f_82480_) * 8000.0));
        buf.writeShort((int)(Math.min(3.9, this.velocity.f_82481_) * 8000.0));
        buf.writeByte((int)((byte)(this.pitch * 256.0f / 360.0f)));
        buf.writeByte((int)((byte)(this.yaw * 256.0f / 360.0f)));
        CharacterUtils.writeToBuf((FriendlyByteBuf)buf, (Character)this.character);
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("inv", (Tag)this.inventory.writeNbt(new ListTag()));
        buf.m_130079_(compound);
    }

    public static void handle(FriendlyByteBuf var3, NetworkManager.PacketContext var4) {
        AutomatonSpawnPacket packet = new AutomatonSpawnPacket(var3);
        var4.queue(() -> {
            ClientLevel world = (ClientLevel)var4.getPlayer().m_9236_();
            AutomatoneEntity entity = new AutomatoneEntity((EntityType<? extends AutomatoneEntity>)((EntityType)Player2NPC.AUTOMATONE.get()), (Level)world);
            entity.m_20234_(packet.id);
            entity.m_20084_(packet.uuid);
            entity.m_217006_(packet.pos.f_82479_, packet.pos.f_82480_, packet.pos.f_82481_);
            entity.m_6027_(packet.pos.f_82479_, packet.pos.f_82480_, packet.pos.f_82481_);
            entity.m_20256_(packet.velocity);
            entity.m_146926_(packet.pitch);
            entity.m_146922_(packet.yaw);
            entity.setCharacter(packet.character);
            packet.inventory.player = entity;
            entity.inventory = packet.inventory;
            world.m_104627_(packet.id, (Entity)entity);
        });
    }
}

