/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc;

import com.goodbird.player2npc.Player2NPC;
import com.goodbird.player2npc.client.gui.CharacterSelectionScreen;
import com.goodbird.player2npc.client.render.RenderAutomaton;
import com.goodbird.player2npc.client.util.ClientPersistence;
import com.goodbird.player2npc.network.AutomatonSpawnPacket;
import com.mojang.blaze3d.platform.InputConstants;
import com.player2.playerengine.PlayerEngineClient;
import com.player2.playerengine.player2api.utils.STTUtils;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Player2NPCClient {
    private static KeyMapping openCharacterScreenKeybind;
    private static KeyMapping ttsEnableKeybind;
    private static KeyMapping sttKeybind;
    private static long lastHeartbeatTime;

    public static void onInitializeClient() {
        EntityRendererRegistry.register(Player2NPC.AUTOMATONE, RenderAutomaton::new);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)Player2NPC.SPAWN_PACKET_ID, AutomatonSpawnPacket::handle);
        openCharacterScreenKeybind = new KeyMapping("key.player2npc.open_character_screen", InputConstants.Type.KEYSYM, 72, "category.player2npc.keys");
        ttsEnableKeybind = new KeyMapping("key.player2npc.tts_toggle", InputConstants.Type.KEYSYM, 79, "category.player2npc.keys");
        sttKeybind = new KeyMapping("key.player2npc.stt_toggle", InputConstants.Type.KEYSYM, 86, "category.player2npc.keys");
        KeyMappingRegistry.register((KeyMapping)openCharacterScreenKeybind);
        KeyMappingRegistry.register((KeyMapping)ttsEnableKeybind);
        KeyMappingRegistry.register((KeyMapping)sttKeybind);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> {
            if (!ClientPersistence.getTTStatus()) {
                player.sendSystemMessage((Component)Component.literal((String)"Welcome to Player2NPC!"));
                player.sendSystemMessage((Component)Component.literal((String)"To spawn a companion, press H. (Make sure you have at least one selected characeter at player2.game)"));
                player.sendSystemMessage((Component)Component.literal((String)"To toggle text to speech (TTS), press O."));
                ClientPersistence.saveTTSStatus(true);
            }
        });
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (openCharacterScreenKeybind.consumeClick() && client.level != null) {
                client.setScreen((Screen)new CharacterSelectionScreen());
            }
            if (ttsEnableKeybind.consumeClick()) {
                PlayerEngineClient.enabledTTS = !PlayerEngineClient.enabledTTS;
                client.player.sendSystemMessage((Component)Component.literal((String)(PlayerEngineClient.enabledTTS ? "Enabled TTS" : "Disabled TTS")));
            }
            if (sttKeybind.isDown()) {
                STTUtils.setIsListening((boolean)true, (String)"player2-ai-npc-minecraft");
            } else {
                STTUtils.setIsListening((boolean)false, (String)"player2-ai-npc-minecraft");
            }
        });
        ClientTickEvent.CLIENT_PRE.register(client -> STTUtils.update());
    }

    static {
        lastHeartbeatTime = System.nanoTime();
    }
}

