/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.client.gui;

import com.goodbird.player2npc.Player2NPC;
import com.goodbird.player2npc.client.util.SkinManager;
import com.goodbird.player2npc.network.AutomatoneDespawnRequestPacket;
import com.goodbird.player2npc.network.AutomatoneSpawnRequestPacket;
import com.player2.playerengine.player2api.Character;
import dev.architectury.networking.NetworkManager;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class CharacterDetailScreen
extends Screen {
    private final Screen parent;
    private final Character character;

    public CharacterDetailScreen(Screen parent, Character character) {
        super(Component.nullToEmpty((String)"Character Details"));
        this.parent = parent;
        this.character = character;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.nullToEmpty((String)"Summon"), button -> {
            System.out.println("Summoning: " + this.character.name());
            NetworkManager.sendToServer((ResourceLocation)Player2NPC.SPAWN_REQUEST_PACKET_ID, (RegistryFriendlyByteBuf)AutomatoneSpawnRequestPacket.create(Minecraft.getInstance().level.registryAccess(), this.character));
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)null);
            }
        }).bounds(this.width / 2 - 100, this.height - 100, 98, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.nullToEmpty((String)"Despawn"), button -> {
            System.out.println("Summoning: " + this.character.name());
            NetworkManager.sendToServer((ResourceLocation)Player2NPC.DESPAWN_REQUEST_PACKET_ID, (RegistryFriendlyByteBuf)AutomatoneDespawnRequestPacket.create(Minecraft.getInstance().level.registryAccess(), this.character));
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)null);
            }
        }).bounds(this.width / 2 - 100, this.height - 130, 98, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.nullToEmpty((String)"Back"), button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen(this.parent);
            }
        }).bounds(this.width / 2 + 2, this.height - 100, 98, 20).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, this.character.name(), this.width / 2, 130, 0xFFFFFF);
        int headSize = 96;
        int headX = this.width / 2 - headSize / 2;
        int headY = 150;
        ResourceLocation skinId = SkinManager.getSkinIdentifier(this.character.skinURL());
        SkinManager.renderSkinHead(graphics, headX, headY, headSize, skinId);
        int textY = headY + headSize + 15;
        for (FormattedText line : this.font.getSplitter().splitLines(this.character.description(), 200, Style.EMPTY)) {
            graphics.drawCenteredString(this.font, line.getString(), this.width / 2, textY, 0xAAAAAA);
            Objects.requireNonNull(this.font);
            textY += 11;
        }
        super.render(graphics, mouseX, mouseY, delta);
    }
}

