/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.client.render;

import com.goodbird.player2npc.client.util.ImageDownloadAlt;
import com.goodbird.player2npc.client.util.ResourceDownloader;
import com.goodbird.player2npc.companion.AutomatoneEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;

public class RenderAutomaton
extends LivingEntityRenderer<AutomatoneEntity, PlayerModel<AutomatoneEntity>> {
    public RenderAutomaton(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new PlayerModel(ctx.bakeLayer(ModelLayers.PLAYER), false), 0.5f);
        boolean slim = false;
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(ctx.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(ctx.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), ctx.getModelManager()));
        this.addLayer((RenderLayer)new PlayerItemInHandLayer((RenderLayerParent)this, ctx.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ArrowLayer(ctx, (LivingEntityRenderer)this));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, ctx.getModelSet(), ctx.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, ctx.getModelSet()));
        this.addLayer((RenderLayer)new SpinAttackEffectLayer((RenderLayerParent)this, ctx.getModelSet()));
        this.addLayer((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
    }

    public void render(AutomatoneEntity automatoneEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        try {
            this.setModelPose(automatoneEntity);
            super.render((LivingEntity)automatoneEntity, f, g, matrixStack, vertexConsumerProvider, i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vec3 getPositionOffset(AutomatoneEntity automatoneEntity, float f) {
        return automatoneEntity.isCrouching() ? new Vec3(0.0, -0.125, 0.0) : super.getRenderOffset((Entity)automatoneEntity, f);
    }

    private void setModelPose(AutomatoneEntity player) {
        PlayerModel playerEntityModel = (PlayerModel)this.getModel();
        if (player.isSpectator()) {
            playerEntityModel.setAllVisible(false);
            playerEntityModel.head.visible = true;
            playerEntityModel.hat.visible = true;
        } else {
            playerEntityModel.setAllVisible(true);
            playerEntityModel.hat.visible = true;
            playerEntityModel.jacket.visible = true;
            playerEntityModel.leftPants.visible = true;
            playerEntityModel.rightPants.visible = true;
            playerEntityModel.leftSleeve.visible = true;
            playerEntityModel.rightSleeve.visible = true;
            playerEntityModel.crouching = player.isCrouching();
            HumanoidModel.ArmPose armPose = RenderAutomaton.getArmPose(player, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose armPose2 = RenderAutomaton.getArmPose(player, InteractionHand.OFF_HAND);
            if (armPose.isTwoHanded()) {
                HumanoidModel.ArmPose armPose3 = armPose2 = player.getOffhandItem().isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (player.getMainArm() == HumanoidArm.RIGHT) {
                playerEntityModel.rightArmPose = armPose;
                playerEntityModel.leftArmPose = armPose2;
            } else {
                playerEntityModel.rightArmPose = armPose2;
                playerEntityModel.leftArmPose = armPose;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(AutomatoneEntity player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (player.getUsedItemHand() == hand && player.getUseItemRemainingTicks() > 0) {
            UseAnim useAction = itemStack.getUseAnimation();
            if (useAction == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useAction == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAction == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useAction == UseAnim.CROSSBOW && hand == player.getUsedItemHand()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useAction == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (useAction == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if (useAction == UseAnim.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!player.swinging && itemStack.is(Items.CROSSBOW) && CrossbowItem.isCharged((ItemStack)itemStack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(AutomatoneEntity npc) {
        if (npc.textureLocation == null) {
            try {
                boolean fixSkin = true;
                File file = ResourceDownloader.getUrlFile(npc.getCharacter().skinURL(), fixSkin);
                npc.textureLocation = ResourceDownloader.getUrlResourceLocation(npc.getCharacter().skinURL(), fixSkin);
                this.loadSkin(file, npc.textureLocation, npc.getCharacter().skinURL(), fixSkin);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return npc.textureLocation == null ? DefaultPlayerSkin.getDefaultTexture() : npc.textureLocation;
    }

    private void loadSkin(File file, ResourceLocation resource, String par1Str, boolean fix64) {
        TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
        AbstractTexture object = texturemanager.getTexture(resource, (AbstractTexture)null);
        if (object == null) {
            ResourceDownloader.load(new ImageDownloadAlt(file, par1Str, resource, DefaultPlayerSkin.getDefaultTexture(), fix64, () -> {}));
        }
    }

    protected void scale(AutomatoneEntity automatoneEntity, PoseStack matrixStack, float f) {
        float g = 0.9375f;
        matrixStack.scale(0.9375f, 0.9375f, 0.9375f);
    }

    protected void setupTransforms(AutomatoneEntity automatoneEntity, PoseStack matrixStack, float f, float g, float h) {
        float i = automatoneEntity.getSwimAmount(h);
        if (automatoneEntity.isFallFlying()) {
            super.setupRotations((LivingEntity)automatoneEntity, matrixStack, f, g, h, i);
            float j = (float)automatoneEntity.getFallFlyingTicks() + h;
            float k = Mth.clamp((float)(j * j / 100.0f), (float)0.0f, (float)1.0f);
            if (!automatoneEntity.isAutoSpinAttack()) {
                matrixStack.mulPose(Axis.XP.rotationDegrees(k * (-90.0f - automatoneEntity.getXRot())));
            }
            Vec3 vec3d = automatoneEntity.getViewVector(h);
            Vec3 vec3d2 = automatoneEntity.lerpVelocity(h);
            double d = vec3d2.horizontalDistanceSqr();
            double e = vec3d.horizontalDistanceSqr();
            if (d > 0.0 && e > 0.0) {
                double l = (vec3d2.x * vec3d.x + vec3d2.z * vec3d.z) / Math.sqrt(d * e);
                double m = vec3d2.x * vec3d.z - vec3d2.z * vec3d.x;
                matrixStack.mulPose(Axis.YP.rotation((float)(Math.signum(m) * Math.acos(l))));
            }
        } else if (i > 0.0f) {
            super.setupRotations((LivingEntity)automatoneEntity, matrixStack, f, g, h, i);
            float j = automatoneEntity.isInWater() ? -90.0f - automatoneEntity.getXRot() : -90.0f;
            float k = Mth.lerp((float)i, (float)0.0f, (float)j);
            matrixStack.mulPose(Axis.XP.rotationDegrees(k));
            if (automatoneEntity.isVisuallySwimming()) {
                matrixStack.translate(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.setupRotations((LivingEntity)automatoneEntity, matrixStack, f, g, h, i);
        }
    }
}

