/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.errors;

import com.gitlab.srcmc.rctapi.api.errors.RCTError;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RCTException
extends RuntimeException {
    private List<RCTError> errors;

    public RCTException(@NotNull List<RCTError> errors) {
        this.errors = errors;
    }

    @NotNull
    public List<RCTError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Override
    public String getMessage() {
        for (RCTError error : this.errors) {
            if (error.message == null || error.message.length() <= 0) continue;
            return error.message;
        }
        return null;
    }

    @Override
    public Throwable getCause() {
        for (RCTError error : this.errors) {
            if (error.cause == null) continue;
            return error.cause;
        }
        return null;
    }
}

