/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.events;

import com.gitlab.srcmc.rctapi.api.events.Event;
import com.gitlab.srcmc.rctapi.api.events.EventListener;
import com.gitlab.srcmc.rctapi.api.events.EventType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;

public class EventContext {
    private static Set<EventListener<?>> EMPTY_SET = new HashSet();
    private Map<EventType<?>, Set<EventListener<?>>> listeners = new HashMap();

    public <T> void register(@NotNull EventType<T> type, @NotNull EventListener<T> listener) {
        this.listeners.computeIfAbsent(type, t -> new CopyOnWriteArraySet()).add(listener);
    }

    public <T> void unregister(@NotNull EventListener<T> listener) {
        this.listeners.values().forEach(s -> s.remove(listener));
    }

    public <T> void unregister(@NotNull EventType<T> type, @NotNull EventListener<T> listener) {
        this.listeners.getOrDefault(type, EMPTY_SET).remove(listener);
    }

    public <T> void fire(@NotNull Event<T> event) {
        this.listeners.getOrDefault(event.getType(), EMPTY_SET).forEach(el -> el.notify(event));
    }
}

