/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.util;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class Text
implements Serializable,
Comparable<Text> {
    private static final long serialVersionUID = 0L;
    private static Gson GSON = new Gson();
    private String literal;
    private String translatable;
    private transient Cache cache;

    protected Text() {
    }

    public static Text empty() {
        return new Text();
    }

    public static Text literal(String literal) {
        return new Text().setLiteral(literal);
    }

    public static Text translatable(String tranlatable) {
        return new Text().setTranslatable(tranlatable);
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getTranslatable() {
        return this.translatable;
    }

    public boolean isEmpty() {
        return !(this.literal != null && !this.literal.isEmpty() || this.translatable != null && !this.translatable.isEmpty());
    }

    public Text setLiteral(String literal) {
        if (!Objects.equals(this.literal, literal)) {
            this.literal = literal;
            this.cache = null;
        }
        return this;
    }

    public Text setTranslatable(String translatable) {
        if (!Objects.equals(this.translatable, translatable)) {
            this.translatable = translatable;
            this.cache = null;
        }
        return this;
    }

    public Text clearCache() {
        this.cache = new Cache(this);
        return this;
    }

    public class_5250 getComponent(Object ... args) {
        if (this.cache == null) {
            this.cache = new Cache(this);
        }
        if (this.cache.component == null || !Arrays.equals(this.cache.args, args)) {
            this.cache.component = this.translatable != null ? class_2561.method_48322((String)this.translatable, (String)(this.literal == null ? "" : this.literal), (Object[])args) : (this.literal != null ? class_2561.method_43470((String)String.format(this.literal, args)) : class_2561.method_43473());
        }
        return this.cache.component;
    }

    public int hashCode() {
        return Objects.hash(this.literal, this.translatable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Text)) return false;
        Text o = (Text)obj;
        if (!Objects.equals(this.literal, o.literal)) return false;
        if (!Objects.equals(this.translatable, o.translatable)) return false;
        return true;
    }

    @Override
    public int compareTo(Text o) {
        return this.getComponent(new Object[0]).getString().compareTo(o.getComponent(new Object[0]).getString());
    }

    public String toString() {
        return this.getComponent(new Object[0]).getString();
    }

    private class Cache {
        public class_5250 component;
        public Object[] args;

        private Cache(Text text) {
        }
    }

    public static class Deserializer
    implements JsonDeserializer<Text> {
        public Text deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                String t = json.getAsString();
                return Text.literal(t);
            }
            catch (UnsupportedOperationException e) {
                return (Text)GSON.fromJson(json, typeOfT);
            }
        }
    }
}

