/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.client;

import com.gitlab.srcmc.rctapi.ModCommon;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Supplier;
import net.minecraft.class_310;

public class ClientTasks {
    public static final ClientTasks BATTLE_SELECTIONS = new ClientTasks();
    private static final long PREDICATE_CHECK_TIMEOUT = 200L;
    private Queue<Thread> tasks = new LinkedList<Thread>();

    public void run(Runnable task) {
        this.addTask(() -> class_310.method_1551().execute(task));
    }

    public void runIf(Runnable task, Supplier<Boolean> predicate) {
        this.runIf(task, predicate, 0L);
    }

    public void runIf(Runnable task, Supplier<Boolean> predicate, long maxTimeout) {
        this.addTask(() -> {
            try {
                long t;
                for (t = 0L; t < maxTimeout && !((Boolean)predicate.get()).booleanValue(); t += 200L) {
                    Thread.sleep(200L);
                }
                if (t >= maxTimeout) {
                    ModCommon.LOG.warn("battle got unexpectedly stuck, attempt to force continuation...");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            class_310.method_1551().execute(task);
        });
    }

    public void sleepThenRun(long millis, Runnable task) {
        this.addTask(() -> {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            class_310.method_1551().execute(task);
        });
    }

    public void waitThenRun(Runnable task) {
        this.addTask(() -> {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            class_310.method_1551().execute(task);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueCurrent() {
        Queue<Thread> queue = this.tasks;
        synchronized (queue) {
            Thread current = this.tasks.peek();
            if (current != null) {
                current.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        int size;
        Queue<Thread> queue = this.tasks;
        synchronized (queue) {
            size = this.tasks.size();
        }
        return size > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread addTask(Runnable task) {
        Thread t = new Thread(task);
        new Thread(() -> {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Queue<Thread> queue = this.tasks;
            synchronized (queue) {
                this.tasks.poll();
                if (!this.tasks.isEmpty()) {
                    this.tasks.peek().start();
                }
            }
        }).start();
        Queue<Thread> queue = this.tasks;
        synchronized (queue) {
            this.tasks.offer(t);
            if (this.tasks.size() == 1) {
                t.start();
            }
        }
        return t;
    }
}

