/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.pokemon.PokemonPropertyExtractor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleEffects;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class BattleStates {
    private static Map<UUID, BattleState> STATES = new HashMap<UUID, BattleState>();

    public static BattleState get(PokemonBattle battle) {
        if (!battle.getEnded()) {
            return STATES.computeIfAbsent(battle.getBattleId(), k -> new BattleState());
        }
        return new BattleState();
    }

    public static Pokemon getTransformationOrEffected(BattlePokemon pkmn) {
        Pokemon transformation = BattleStates.get(pkmn.actor.battle).getPokemonState(pkmn).getTransformation();
        return transformation != null ? transformation : pkmn.getEffectedPokemon();
    }

    public static void notifyBattleEnded(PokemonBattle battle) {
        STATES.remove(battle.getBattleId());
    }

    private BattleStates() {
    }

    public static class BattleState {
        private Map<BattlePokemon, PokemonState> pokemonStates = new HashMap<BattlePokemon, PokemonState>();
        private Map<BattleActor, ActorState> actorStates = new HashMap<BattleActor, ActorState>();

        private BattleState() {
        }

        public PokemonState getPokemonState(BattlePokemon pkmn) {
            return this.pokemonStates.computeIfAbsent(pkmn, k -> new PokemonState());
        }

        public ActorState getActorState(BattleActor actor) {
            return this.actorStates.computeIfAbsent(actor, k -> new ActorState());
        }
    }

    public static class PokemonState {
        private static final int[] ZERO = new int[]{0};
        private Map<BattleEffects.Custom, int[]> turnEffectCounters = new HashMap<BattleEffects.Custom, int[]>();
        private Pokemon transformation;
        private long effects;

        private PokemonState() {
        }

        public void nextTurn() {
            if (!this.has(BattleEffects.Custom.TURN)) {
                this.add(BattleEffects.Custom.TURN);
            }
            Iterator<Map.Entry<BattleEffects.Custom, int[]>> it = this.turnEffectCounters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<BattleEffects.Custom, int[]> e = it.next();
                int[] nArray = e.getValue();
                int n = nArray[0];
                nArray[0] = n - 1;
                if (n > 0) continue;
                this.effects ^= e.getKey().mask();
                it.remove();
            }
        }

        public void setTransformation(BattlePokemon target) {
            this.transformation = target.getEffectedPokemon().createPokemonProperties(PokemonPropertyExtractor.ALL).create();
        }

        public Pokemon getTransformation() {
            return this.transformation;
        }

        public boolean has(BattleEffects.Custom e) {
            return (e.mask() & this.effects) != 0L;
        }

        public int age(BattleEffects.Custom e) {
            return this.has(e) ? e.expires() - this.turnEffectCounters.getOrDefault((Object)e, ZERO)[0] : 0;
        }

        public void add(BattleEffects.Custom e) {
            if (e.expires() >= 0) {
                this.turnEffectCounters.put(e, new int[]{e.expires()});
            }
            this.effects |= e.mask();
        }

        public void onSwitch(BattlePokemon target) {
            PokemonState targetState = BattleStates.get(target.actor.battle).getPokemonState(target);
            for (BattleEffects.Custom e : BattleEffects.Custom.values()) {
                if (e.isVolatile() && (targetState.effects & e.mask()) != 0L) {
                    targetState.effects ^= e.mask();
                    targetState.turnEffectCounters.remove((Object)e);
                }
                if (e.canBePassed() && (this.effects & e.mask()) != 0L) {
                    targetState.effects |= e.mask();
                    if (e.expires() >= 0) {
                        targetState.turnEffectCounters.put(e, this.turnEffectCounters.get((Object)e));
                    }
                }
                if (!e.isVolatile() || (this.effects & e.mask()) == 0L) continue;
                this.effects ^= e.mask();
                this.turnEffectCounters.remove((Object)e);
            }
            this.transformation = null;
            targetState.transformation = null;
        }
    }

    public static class ActorState {
        private final Set<BattlePokemon> switchChoices = new HashSet<BattlePokemon>();
        private final Set<String> gimmicks = new HashSet<String>();

        public void addGimmick(String showdownId) {
            this.gimmicks.add(showdownId);
        }

        public boolean hasGimmick(String showdownId) {
            return this.gimmicks.contains(showdownId);
        }

        public void setWillBeSwitchedIn(BattlePokemon pkmn) {
            this.setWillBeSwitchedIn(pkmn, true);
        }

        public void setWillBeSwitchedIn(BattlePokemon pkmn, boolean value) {
            if (value) {
                this.switchChoices.add(pkmn);
            } else {
                this.switchChoices.remove(pkmn);
            }
        }

        public boolean willBeSwitchedIn(BattlePokemon pkmn) {
            return this.switchChoices.contains(pkmn);
        }

        public void nextRequest() {
            this.switchChoices.clear();
        }
    }
}

