/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.DefaultActionResponse;
import com.cobblemon.mod.common.battles.ForcePassActionResponse;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.MoveActionResponse;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionRequest;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.SwitchActionResponse;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.gitlab.srcmc.rctapi.ModCommon;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleEffects;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.ai.utils.Debug;
import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;

public class ResponseBuilder {
    private Supplier<Stream<BattlePokemon>> switchCandidates = Stream::empty;
    private Supplier<Stream<Pair<BagItem, BattlePokemon>>> itemCandidates = Stream::empty;
    private Supplier<Stream<Pair<InBattleMove, Targetable>>> moveCandidates = Stream::empty;
    private List<Choice<ShowdownActionResponse>> choices = new ArrayList<Choice<ShowdownActionResponse>>();
    private Random rng = new Random(0L);
    private ActiveBattlePokemon pkmn;
    private ShowdownMoveset moveset;
    private boolean forceSwitch;
    private boolean forceMove;
    private boolean mustChoose;
    private double margin;
    private ShowdownActionResponse response;
    private static final int MAX_CHOICE_RNG = 16;

    public static ResponseBuilder create(ActiveBattlePokemon pkmn, ShowdownMoveset moveset, boolean forceSwitch) {
        ResponseBuilder builder = new ResponseBuilder();
        ShowdownActionRequest request = pkmn.getActor().getRequest();
        builder.mustChoose = pkmn.getActor().getMustChoose();
        builder.forceSwitch = forceSwitch;
        builder.forceMove = false;
        builder.moveset = moveset;
        builder.pkmn = pkmn;
        if (!(request.getWait() || !forceSwitch && request.getForceSwitch().contains(true))) {
            if (!builder.forceSwitch && pkmn.hasPokemon()) {
                ResponseBuilder.selectMoves(pkmn, builder);
                if (!builder.forceMove) {
                    ResponseBuilder.selectItemUsages(pkmn, builder);
                }
            }
            if (!builder.forceMove) {
                ResponseBuilder.selectSwitches(pkmn, builder);
            }
        }
        return builder;
    }

    private static void selectMoves(ActiveBattlePokemon pkmn, ResponseBuilder builder) {
        if (builder.moveset != null && builder.moveset.moves.stream().findFirst().isPresent()) {
            Stream<InBattleMove> stream;
            if (builder.moveset.moves.stream().anyMatch(InBattleMove::mustBeUsed)) {
                stream = builder.moveset.moves.stream().filter(InBattleMove::mustBeUsed);
                builder.forceMove = true;
            } else {
                stream = builder.moveset.moves.stream().filter(InBattleMove::canBeUsed);
            }
            builder.moveCandidates = () -> stream.flatMap(mv -> mv.getTargets(pkmn) == null || mv.getTargets(pkmn).isEmpty() ? Stream.of(new Pair<InBattleMove, Targetable>((InBattleMove)mv, null)) : mv.getTargets(pkmn).stream().map(t -> new Pair<InBattleMove, Targetable>((InBattleMove)mv, (Targetable)t)));
        }
    }

    private static void selectSwitches(ActiveBattlePokemon pkmn, ResponseBuilder builder) {
        builder.switchCandidates = () -> pkmn.getActor().getPokemonList().stream().filter(p -> p.canBeSentOut());
    }

    private static void selectItemUsages(ActiveBattlePokemon pkmn, ResponseBuilder builder) {
        BattleActor battleActor;
        if (pkmn.getActor().canFitForcedAction() && (battleActor = pkmn.getActor()) instanceof BattleManager.TrainerEntityBattleActor) {
            BattleManager.TrainerEntityBattleActor actor = (BattleManager.TrainerEntityBattleActor)battleActor;
            builder.itemCandidates = () -> actor.getBag().getItems().stream().flatMap(bi -> pkmn.getActor().getPokemonList().stream().filter(p -> bi.canUse(BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)bi.getItemName())).orElse(Items.AIR).getDefaultInstance(), pkmn.getBattle(), p)).map(p -> new Pair<BagItem, BattlePokemon>((BagItem)bi, (BattlePokemon)p)));
        }
    }

    public ResponseBuilder suggestSwitches(Function<Stream<BattlePokemon>, Stream<Choice<BattlePokemon>>> consumer) {
        consumer.apply(this.switchCandidates.get()).forEach(choice -> {
            SwitchActionResponse response = new SwitchActionResponse(((BattlePokemon)choice.value).getUuid());
            this.choices.add(new Choice<SwitchActionResponse>(choice.name, response, choice.weight, () -> {
                ((BattlePokemon)choice.value).setWillBeSwitchedIn(true);
                if (this.pkmn.hasPokemon()) {
                    this.pkmn.getBattlePokemon().setWillBeSwitchedIn(false);
                }
            }));
        });
        return this;
    }

    public ResponseBuilder suggestItems(Function<Stream<Pair<BagItem, BattlePokemon>>, Stream<Choice<Pair<BagItem, BattlePokemon>>>> consumer) {
        BattleActor battleActor = this.pkmn.getActor();
        if (battleActor instanceof BattleManager.TrainerEntityBattleActor) {
            BattleManager.TrainerEntityBattleActor actor = (BattleManager.TrainerEntityBattleActor)battleActor;
            consumer.apply(this.itemCandidates.get()).forEach(choice -> {
                ForcePassActionResponse response = new ForcePassActionResponse();
                this.choices.add(new Choice<ForcePassActionResponse>(choice.name, response, choice.weight, () -> {
                    BagItem item = (BagItem)((Pair)choice.value).first;
                    BattlePokemon pkmn = (BattlePokemon)((Pair)choice.value).second;
                    this.pkmn.getActor().forceChoose((ShowdownActionResponse)new BagItemActionResponse(actor.getBag().use(item), pkmn, pkmn.getUuid().toString()));
                }, true));
            });
        }
        return this;
    }

    public ResponseBuilder suggestMoves(Function<Stream<Pair<InBattleMove, Targetable>>, Stream<Choice<Pair<InBattleMove, Targetable>>>> consumer) {
        ShowdownMoveset.Gimmick gimmick = this.moveset != null && this.moveset.getGimmicks().size() > 0 ? (ShowdownMoveset.Gimmick)this.moveset.getGimmicks().get(this.rng.nextInt(this.moveset.getGimmicks().size())) : null;
        Debug.log(1, () -> {
            ModCommon.LOG.info("[GIMMICKS of " + (this.pkmn.hasPokemon() ? this.pkmn.getBattlePokemon().getName().getString() : "<dead>") + "]:");
            if (this.moveset != null) {
                this.moveset.getGimmicks().forEach(g -> ModCommon.LOG.info(" - " + g.getId() + ", " + g.name()));
            }
            if (gimmick != null) {
                ModCommon.LOG.info("ACTIVATED: " + gimmick.getId());
            }
        });
        BattleStates.BattleState battleState = BattleStates.get(this.pkmn.getBattle());
        BattleStates.ActorState actorSt = battleState.getActorState(this.pkmn.getActor());
        consumer.apply(this.moveCandidates.get()).forEach(choice -> {
            InBattleMove move = (InBattleMove)((Pair)choice.value).first;
            MoveTemplate moveInstance = Moves.getByName((String)move.id);
            Targetable target = (Targetable)((Pair)choice.value).second;
            String gimmickId = moveInstance != null && gimmick != null && (!ShowdownMoveset.Gimmick.Z_POWER.equals((Object)gimmick) || move.getGimmickMove() != null) ? gimmick.getId() : null;
            boolean max = ShowdownMoveset.Gimmick.DYNAMAX.getId().equals(gimmickId);
            boolean status = moveInstance == null ? false : Moves.getByName((String)move.id).getDamageCategory().equals(DamageCategories.INSTANCE.getSTATUS());
            MoveActionResponse response = new MoveActionResponse(move.id, (!max || !status) && target != null ? target.getPNX() : null, gimmickId);
            this.choices.add(new Choice<MoveActionResponse>(choice.name, response, choice.weight, () -> {
                if (this.pkmn.hasPokemon() && gimmickId != null) {
                    if (ShowdownMoveset.Gimmick.DYNAMAX.getId().equals(gimmickId)) {
                        battleState.getPokemonState(this.pkmn.getBattlePokemon()).add(BattleEffects.Custom.DYNAMAX);
                    } else if (ShowdownMoveset.Gimmick.MEGA_EVOLUTION.getId().equals(gimmickId)) {
                        battleState.getPokemonState(this.pkmn.getBattlePokemon()).add(BattleEffects.Custom.MEGA);
                    } else if (ShowdownMoveset.Gimmick.TERASTALLIZATION.getId().equals(gimmickId)) {
                        battleState.getPokemonState(this.pkmn.getBattlePokemon()).add(BattleEffects.Custom.TERA);
                    } else if (ShowdownMoveset.Gimmick.Z_POWER.getId().equals(gimmickId) || ShowdownMoveset.Gimmick.ULTRA_BURST.getId().equals(gimmickId)) {
                        battleState.getPokemonState(this.pkmn.getBattlePokemon()).add(BattleEffects.Custom.ZMOVE);
                    }
                    actorSt.addGimmick(gimmickId);
                }
            }));
        });
        return this;
    }

    public ShowdownActionResponse response(MessagePassingQueue.Consumer<ShowdownActionResponse> consumer) {
        Debug.log(1, "[CHOICES OF %s]:%s", this.pkmn.isAlive() ? this.pkmn.getBattlePokemon().getName().getString() : "<dead>", ", forceMove: " + this.forceMove + ", forceSwitch: " + this.forceSwitch + ", mustChoose: " + this.mustChoose);
        Debug.log(1, () -> this.choices.stream().sorted().forEach(c -> ModCommon.LOG.info(String.format(" - %s: %.4f, forced: %b, valid: %b", c.name, c.weight, c.forced, ((ShowdownActionResponse)c.value).isValid(this.pkmn, this.moveset, this.forceSwitch)))));
        List<Choice> choices = this.choices.stream().filter(c -> c.forced || ((ShowdownActionResponse)c.value).isValid(this.pkmn, this.moveset, this.forceSwitch)).toList();
        ShowdownActionResponse response = this.response != null ? this.response : (choices.isEmpty() ? (this.forceMove && this.mustChoose && this.pkmn.hasPokemon() ? new DefaultActionResponse() : PassActionResponse.INSTANCE) : (ShowdownActionResponse)ResponseBuilder.getRandom(ResponseBuilder.takeWithMargin(choices.stream().sorted(), (double)this.margin), (Random)this.rng, (double)this.margin).orElse(new Choice<DefaultActionResponse>((String)"DEFAULT", new DefaultActionResponse(), (double)0.0)).pick().value);
        consumer.accept((Object)response);
        return response;
    }

    public ShowdownActionResponse response() {
        return this.response((MessagePassingQueue.Consumer<ShowdownActionResponse>)((MessagePassingQueue.Consumer)r -> Debug.log(1, "=> RESPONSE: " + r.toString() + ", " + r.toShowdownString(this.pkmn, this.moveset), new Object[0])));
    }

    public ResponseBuilder margin(double margin) {
        this.margin = margin;
        return this;
    }

    public ResponseBuilder random(Random rng) {
        this.rng = rng;
        return this;
    }

    private static <T> Stream<Choice<T>> takeWithMargin(Stream<Choice<T>> in, double margin) {
        double[] w = new double[]{Double.NEGATIVE_INFINITY};
        return in.takeWhile(choice -> {
            if (w[0] == Double.NEGATIVE_INFINITY) {
                w[0] = choice.weight;
            } else if (choice.weight - w[0] > margin) {
                return false;
            }
            return true;
        });
    }

    private static <T> Optional<Choice<T>> getRandom(Stream<Choice<T>> stream, Random rng, double margin) {
        Choice c;
        Iterator it = stream.iterator();
        if (it.hasNext()) {
            Choice next = (Choice)it.next();
            double start = next.weight;
            double w = 0.0;
            int i = 1;
            c = next;
            while (it.hasNext()) {
                next = (Choice)it.next();
                w = margin > 0.0 ? (next.weight - start) / margin : 1.0;
                if (rng.nextInt(++i + (int)(w * 16.0)) != 0) continue;
                c = next;
            }
        } else {
            c = null;
        }
        return Optional.ofNullable(c);
    }

    public static class Choice<T>
    implements Comparable<Choice<?>> {
        public final T value;
        public final double weight;
        public final String name;
        public final boolean forced;
        private final Action onpick;

        public Choice(String name, T value, double weight) {
            this(name, value, weight, () -> {}, false);
        }

        public Choice(String name, T value, double weight, boolean forced) {
            this(name, value, weight, () -> {}, forced);
        }

        public Choice(String name, T value, double weight, Action onpick) {
            this(name, value, weight, onpick, false);
        }

        public Choice(String name, T value, double weight, Action onpick, boolean forced) {
            this.value = value;
            this.weight = weight;
            this.name = name;
            this.onpick = onpick;
            this.forced = forced;
        }

        public Choice<T> pick() {
            this.onpick.perform();
            return this;
        }

        @Override
        public int compareTo(Choice<?> other) {
            return Double.compare(this.weight, other.weight);
        }

        public static interface Action {
            public void perform();
        }
    }

    public static class Pair<T, U> {
        public final T first;
        public final U second;

        public Pair(T first, U second) {
            this.first = first;
            this.second = second;
        }
    }
}

