/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.example;

import com.gitlab.srcmc.rctapi.ModCommon;
import com.gitlab.srcmc.rctapi.api.RCTApi;
import com.gitlab.srcmc.rctapi.api.errors.RCTException;
import com.gitlab.srcmc.rctapi.api.models.TrainerModel;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerRegistry;
import com.google.gson.Gson;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;

public class ExampleMod {
    private static final String MOD_ID = "example_mod";
    private static final RCTApi RCT = RCTApi.initInstance("example_mod");
    private static final Gson GSON = RCT.gsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private static String fileToId(File file) {
        String name = file.getName().toLowerCase().trim();
        int i = name.lastIndexOf(46);
        return (i < 0 ? name : name.substring(0, i)).replace(' ', '_');
    }

    public static void init() {
        ExampleMod.registerEvents();
    }

    static void registerEvents() {
        LifecycleEvent.SERVER_STARTING.register(ExampleMod::onServerStarting);
        PlayerEvent.PLAYER_JOIN.register(ExampleMod::onPlayerJoin);
        PlayerEvent.PLAYER_QUIT.register(ExampleMod::onPlayerQuit);
    }

    static void onServerStarting(MinecraftServer server) {
        TrainerRegistry trainerRegistry = RCT.getTrainerRegistry();
        trainerRegistry.init(server);
        File trainerDir = Path.of(server.getWorldPath(LevelResource.ROOT).toString(), "..", "..", "trainers").toFile();
        File[] files = trainerDir.listFiles(f -> f.getName().toLowerCase().endsWith(".json"));
        if (files != null) {
            for (File trainerFile : files) {
                try (BufferedReader rd = new BufferedReader(new FileReader(trainerFile));){
                    String trainerId = ExampleMod.fileToId(trainerFile);
                    trainerRegistry.registerNPC(trainerId, (TrainerModel)GSON.fromJson((Reader)rd, TrainerModel.class));
                }
                catch (RCTException errors) {
                    ModCommon.LOG.warn("Model validation failure in: " + trainerFile.getPath() + errors.getErrors().stream().map(e -> e.message).reduce("", (a, b) -> a + "\n  " + b));
                }
                catch (IOException e2) {
                    ModCommon.LOG.error("Failed to parse trainer", (Throwable)e2);
                }
            }
        }
    }

    static void onPlayerJoin(ServerPlayer player) {
        RCT.getTrainerRegistry().registerPlayer(player.getName().getString(), player);
    }

    static void onPlayerQuit(Player player) {
        RCT.getTrainerRegistry().unregisterById(player.getName().getString());
    }
}

