/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.mixins;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.AIBattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.battle.BattleState;
import java.util.List;
import java.util.UUID;
import kotlin.Unit;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BattleActor.class})
public abstract class BattleActorMixin {
    private BattleActor self;

    @Shadow(remap=false)
    abstract PokemonBattle getBattle();

    @Shadow(remap=false)
    abstract List<ActiveBattlePokemon> getActivePokemon();

    @Shadow(remap=false)
    abstract UUID getUuid();

    @Shadow(remap=false)
    abstract void setMustChoose(boolean var1);

    @Inject(method={"<init>*"}, at={@At(value="TAIL")}, remap=false)
    private void inject$init(CallbackInfo ci) {
        this.self = (BattleActor)this;
    }

    @Inject(method={"upkeep()V"}, at={@At(value="TAIL")}, remap=false)
    private void injectUpkeep(CallbackInfo ci) {
        if (BattleState.findFirst(this.getBattle()) != null && this.self instanceof AIBattleActor) {
            this.setMustChoose(false);
            this.getBattle().dispatchGo(() -> {
                this.setMustChoose(true);
                return Unit.INSTANCE;
            });
        }
    }

    @Inject(method={"turn()V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void injectTurn(CallbackInfo ci) {
        if (BattleState.findFirst(this.getBattle()) != null) {
            BattleStates.BattleState bs = BattleStates.get(this.getBattle());
            this.getActivePokemon().stream().filter(ActiveBattlePokemon::hasPokemon).forEach(pkmn -> bs.getPokemonState(pkmn.getBattlePokemon()).nextTurn());
        }
    }

    @Inject(method={"canFitForcedAction()Z"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void injectCanFitForcedAction(CallbackInfoReturnable<Boolean> cir) {
        int maxItems;
        BattleState battleState;
        if (((Boolean)cir.getReturnValue()).booleanValue() && (battleState = BattleState.findFirst(this.getBattle())) != null && (maxItems = battleState.getRules().getMaxItemUses()) >= 0) {
            BattleState.ActorState actorState = battleState.getState(this.getUuid());
            cir.setReturnValue((Object)(actorState.getItemsUsed() < maxItems ? 1 : 0));
        }
    }
}

