/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.mixins;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleCaptureAction;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.dispatch.BattleDispatch;
import com.gitlab.srcmc.rctapi.api.battle.BattleState;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonBattle.class})
public abstract class PokemonBattleMixin {
    private PokemonBattle self;

    @Shadow(remap=false)
    abstract BattleFormat getFormat();

    @Shadow(remap=false)
    abstract Iterable<BattleActor> getActors();

    @Shadow(remap=false)
    abstract List<BattleCaptureAction> getCaptureActions();

    @Shadow(remap=false)
    abstract Pair<BattleActor, ActiveBattlePokemon> getActorAndActiveSlotFromPNX(String var1);

    @Shadow(remap=false)
    abstract boolean checkForfeit();

    @Shadow(remap=false)
    abstract int getTurn();

    @Shadow(remap=false)
    abstract ConcurrentLinkedDeque<BattleDispatch> getDispatches();

    @Shadow(remap=false)
    abstract List<Function0<Unit>> getAfterDispatches();

    @Shadow(remap=false)
    abstract void checkForInputDispatch();

    @Inject(method={"<init>*"}, at={@At(value="TAIL")}, remap=false)
    private void inject$init(CallbackInfo ci) {
        this.self = (PokemonBattle)this;
    }

    @Inject(method={"checkForInputDispatch()V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void injectCheckForInputDispatch(CallbackInfo ci) {
        if (BattleState.findFirst(this.self) != null) {
            if (this.checkForfeit()) {
                ci.cancel();
                return;
            }
            List<BattleActor> actors = Streams.stream(this.getActors()).filter(a -> a.getPokemonList().stream().anyMatch(p -> p.getHealth() > 0)).toList();
            boolean readyToInput = actors.stream().allMatch(a -> !a.getMustChoose() && (!a.getResponses().isEmpty() || a.getRequest() == null || a.getRequest().getWait()));
            if (readyToInput && this.getCaptureActions().isEmpty()) {
                actors.stream().forEach(a -> {
                    if (!a.getResponses().isEmpty()) {
                        a.writeShowdownResponse();
                    } else {
                        a.setRequest(null);
                    }
                });
            }
            ci.cancel();
        }
    }
}

