/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.TerastallizationEvent;
import com.cobblemon.mod.common.api.events.entity.PokemonEntitySaveToWorldEvent;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctapi.IModLoader;
import com.gitlab.srcmc.rctapi.api.RCTApi;
import com.gitlab.srcmc.rctapi.api.ai.config.RCTBattleAIConfig;
import com.gitlab.srcmc.rctapi.api.ai.config.SelfdotGen5AIConfig;
import com.gitlab.srcmc.rctapi.api.ai.config.StrongBattleAIConfig;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleEffects;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import dev.architectury.event.events.common.TickEvent;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModCommon {
    public static final String MOD_ID = "rctapi";
    public static final Logger LOG = LoggerFactory.getLogger((String)"rctapi");
    private static IModLoader modLoader = modId -> false;

    public static void init(IModLoader modLoader) {
        ModCommon.modLoader = modLoader;
        RCTBattleAIConfig.register();
        StrongBattleAIConfig.register();
        SelfdotGen5AIConfig.register();
        TickEvent.SERVER_POST.register(ModCommon::handleServerTick);
        CobblemonEvents.POKEMON_ENTITY_SAVE_TO_WORLD.subscribe(Priority.HIGH, ModCommon::handlePokemonEntitySaveToWorld);
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, ModCommon::handleBattleVictory);
        CobblemonEvents.BATTLE_FLED.subscribe(Priority.NORMAL, ModCommon::handleBattleFled);
        CobblemonEvents.TERASTALLIZATION.subscribe(Priority.NORMAL, ModCommon::handleTerastallization);
    }

    public static IModLoader modLoader() {
        return modLoader;
    }

    static void handleServerTick(MinecraftServer server) {
        BattleManager.tick();
    }

    static void handleTerastallization(TerastallizationEvent e) {
        BattleStates.get(e.getBattle()).getPokemonState(e.getPokemon()).add(BattleEffects.Custom.TERA);
    }

    static void handlePokemonEntitySaveToWorld(PokemonEntitySaveToWorldEvent event) {
        Pokemon pkmn = event.getPokemonEntity().getPokemon();
        if (pkmn.getOriginalTrainer() != null && RCTApi.getInstances().map(e -> (RCTApi)e.getValue()).anyMatch(api -> api.getTrainerRegistry().getByOT(pkmn) instanceof TrainerNPC)) {
            event.cancel();
        }
    }

    static void handleBattleVictory(BattleVictoryEvent event) {
        PokemonBattle battle = event.getBattle();
        battle.setWinners(event.getWinners());
        battle.setLosers(event.getLosers());
        BattleManager.queryToEnd(event.getBattle());
    }

    static void handleBattleFled(BattleFledEvent event) {
        BattleStates.notifyBattleEnded(event.getBattle());
    }
}

