/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.battle;

import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.battles.AlreadyInBattleError;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.BattleStartError;
import com.cobblemon.mod.common.battles.BattleType;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.gitlab.srcmc.rctapi.api.RCTApi;
import com.gitlab.srcmc.rctapi.api.battle.BattleContext;
import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class BattleContextValidator {
    public ErroredBattleStart validate(ErroredBattleStart errors, BattleContext context) {
        BattleActor primaryActor;
        BattleType battleType = context.getBattleFormat().getCobblemonBattleFormat().getBattleType();
        int actorsPersSide = battleType.getActorsPerSide();
        int slotsPerActor = battleType.getSlotsPerActor();
        HashSet<UUID> actorIds = new HashSet<UUID>();
        if (context.getBattleSide1().getActors().length > 0 && !((primaryActor = context.getBattleSide1().getActors()[0]) instanceof PlayerBattleActor)) {
            errors.getParticipantErrors().get(primaryActor).add(BattleStartError.Companion.canceledByEvent(Component.literal((String)String.format("Primary actor '%s' is not a player", primaryActor.getName().getString()))));
        }
        for (BattleSide side : List.of(context.getBattleSide1(), context.getBattleSide2())) {
            if (side.getActors().length != actorsPersSide) {
                errors.getGeneralErrors().add(BattleStartError.Companion.incorrectActorCount(actorsPersSide, side.getActors().length));
            }
            for (BattleActor actor : side.getActors()) {
                EntityBackedBattleActor entityBacked;
                Iterator it = RCTApi.getInstances().map(e -> (RCTApi)e.getValue()).iterator();
                while (it.hasNext()) {
                    BattleManager bm = ((RCTApi)it.next()).getBattleManager();
                    if (!bm.getStates().stream().anyMatch(bs -> bs.getBattle().getActor(actor.getUuid()) != null)) continue;
                    errors.getParticipantErrors().get(actor).add(AlreadyInBattleError.Companion.alreadyInBattle(actor));
                    break;
                }
                if (actor instanceof EntityBackedBattleActor && (entityBacked = (EntityBackedBattleActor)actor).getEntity() != null && !entityBacked.getEntity().getTags().contains("rctapi:dummy") && entityBacked.getEntity().isAlive()) {
                    if (!entityBacked.getEntity().level().isLoaded(entityBacked.getEntity().blockPosition())) {
                        errors.getParticipantErrors().get(actor).add(BattleStartError.Companion.canceledByEvent(Component.literal((String)String.format("%s is too far away (not loaded)", actor.getName().getString()))));
                    }
                    if (actor.getPokemonList().size() < slotsPerActor) {
                        errors.getParticipantErrors().get(actor).add(BattleStartError.Companion.insufficientPokemon((Entity)entityBacked.getEntity(), slotsPerActor, actor.getPokemonList().size()));
                    }
                    if (actorIds.contains(actor.getUuid())) {
                        errors.getParticipantErrors().get(actor).add(AlreadyInBattleError.Companion.alreadyInBattle(actor));
                        continue;
                    }
                    actorIds.add(actor.getUuid());
                    continue;
                }
                errors.getParticipantErrors().get(actor).add(BattleStartError.Companion.canceledByEvent(Component.literal((String)String.format("%s is not attached to an entity", actor.getName().getString()))));
            }
        }
        return errors;
    }
}

