/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.mixins;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.AIBattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.ShowdownActionRequest;
import com.cobblemon.mod.common.battles.interpreter.instructions.RequestInstruction;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMakeChoicePacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleQueueRequestPacket;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.battle.BattleState;
import kotlin.Unit;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RequestInstruction.class})
public abstract class RequestInstructionMixin {
    @Shadow(remap=false)
    abstract BattleActor getBattleActor();

    @Shadow(remap=false)
    abstract BattleMessage getMessage();

    @Inject(method={"invoke(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void injectInvoke(PokemonBattle battle, CallbackInfo ci) {
        if (BattleState.findFirst(battle) != null) {
            battle.log("Request Instruction");
            BattleMessage message = this.getMessage();
            BattleActor actor = this.getBattleActor();
            if (message.getRawMessage().contains("teamPreview")) {
                ci.cancel();
                return;
            }
            if (this.getBattleActor() instanceof AIBattleActor) {
                BattleStates.get(battle).getActorState(actor).nextRequest();
            }
            ShowdownActionRequest request = (ShowdownActionRequest)BattleRegistry.INSTANCE.getGson().fromJson(message.getRawMessage().split("\\|request\\|")[1], ShowdownActionRequest.class);
            request.sanitize(battle, actor);
            battle.dispatchGo(() -> {
                actor.sendUpdate((NetworkPacket)new BattleQueueRequestPacket(request));
                actor.setRequest(request);
                actor.getResponses().clear();
                if (request.getForceSwitch().contains(true)) {
                    battle.doWhenClear(() -> {
                        actor.setMustChoose(actor.getRequest() != null);
                        if (actor.getRequest() == null) {
                            battle.dispatchToFront(() -> {
                                battle.checkForInputDispatch();
                                return () -> true;
                            });
                        } else if (actor.getMustChoose()) {
                            actor.sendUpdate((NetworkPacket)new BattleMakeChoicePacket());
                        }
                        return Unit.INSTANCE;
                    });
                }
                return Unit.INSTANCE;
            });
            ci.cancel();
        }
    }
}

