/*
 * Decompiled with CFR 0.152.
 */
package com.ylkkx.crtadd.mods.everlastingabilities;

import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import net.minecraft.entity.player.EntityPlayer;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.ability.AbilityTypeRegistry;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenExpansion(value="crafttweaker.player.IPlayer")
@ModOnly(value="everlastingabilities")
public class IPlayerAbilites {
    @ZenMethod
    public static boolean hasAbilites(IPlayer player, String abilitesname) {
        String fullAbilityName = "ability.abilities.everlastingabilities." + abilitesname + ".name";
        IAbilityType abilityType = AbilityTypeRegistry.getInstance().getAbilityType(fullAbilityName);
        if (abilityType == null) {
            return false;
        }
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        IMutableAbilityStore abilityStore = (IMutableAbilityStore)mcPlayer.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        return abilityStore.hasAbilityType(abilityType);
    }

    @ZenMethod
    public static int getAbilitesLevel(IPlayer player, String abilitesname) {
        String fullAbilityName = "ability.abilities.everlastingabilities." + abilitesname + ".name";
        IAbilityType abilityType = AbilityTypeRegistry.getInstance().getAbilityType(fullAbilityName);
        if (abilityType == null) {
            return 0;
        }
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        IMutableAbilityStore abilityStore = (IMutableAbilityStore)mcPlayer.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        return abilityStore.getAbility(abilityType).getLevel();
    }

    @ZenMethod
    public static void addAbilites(IPlayer player, String abilitesname, int level, boolean modifyXp) {
        String fullAbilityName = "ability.abilities.everlastingabilities." + abilitesname + ".name";
        IAbilityType abilityType = AbilityTypeRegistry.getInstance().getAbilityType(fullAbilityName);
        if (abilityType != null) {
            EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
            Ability newAbility = new Ability(abilityType, level);
            Ability ability = AbilityHelpers.addPlayerAbility((EntityPlayer)mcPlayer, (Ability)newAbility, (boolean)true, (boolean)modifyXp);
        }
    }

    @ZenMethod
    public static void removeAbilites(IPlayer player, String abilitesname, int level, boolean modifyXp) {
        String fullAbilityName = "ability.abilities.everlastingabilities." + abilitesname + ".name";
        IAbilityType abilityType = AbilityTypeRegistry.getInstance().getAbilityType(fullAbilityName);
        if (abilityType != null) {
            EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
            Ability newAbility = new Ability(abilityType, level);
            Ability ability = AbilityHelpers.removePlayerAbility((EntityPlayer)mcPlayer, (Ability)newAbility, (boolean)true, (boolean)modifyXp);
        }
    }

    @ZenGetter(value="getPlayerAbiliteCount")
    public static int getPlayerAbiliteCount(IPlayer player) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        IMutableAbilityStore abilityStore = (IMutableAbilityStore)mcPlayer.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        return abilityStore.getAbilities().size();
    }
}

