/*
 * Decompiled with CFR 0.152.
 */
package oas.work.custom_clear_lag.procedures;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import oas.work.custom_clear_lag.network.CustomClearLagModVariables;

@EventBusSubscriber
public class ExecuteProcedure {
    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        ExecuteProcedure.execute((Event)event, (LevelAccessor)event.getLevel());
    }

    public static void execute(LevelAccessor world) {
        ExecuteProcedure.execute(null, world);
    }

    private static void execute(@Nullable Event event, LevelAccessor world) {
        if (!CustomClearLagModVariables.MapVariables.get((LevelAccessor)world).stop) {
            int timeThreshold = ExecuteProcedure.loadTimeFromConfig(world);
            String commandToExecute = ExecuteProcedure.loadCommandFromConfig(world);
            if (CustomClearLagModVariables.MapVariables.get((LevelAccessor)world).time >= (double)(timeThreshold * 1200)) {
                if (world instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)world;
                    _level.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, new Vec3(0.0, 0.0, 0.0), Vec2.ZERO, _level, 4, "", (Component)Component.literal((String)""), _level.getServer(), null).withSuppressedOutput(), commandToExecute);
                    CustomClearLagModVariables.MapVariables.get((LevelAccessor)world).time = 0.0;
                }
            } else {
                CustomClearLagModVariables.MapVariables.get((LevelAccessor)world).time += 1.0;
                CustomClearLagModVariables.MapVariables.get(world).syncData(world);
            }
        }
    }

    private static int loadTimeFromConfig(LevelAccessor world) {
        int n;
        File configFile = new File("config/oas_work/clear_lag.json");
        FileReader reader = new FileReader(configFile);
        try {
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            n = jsonObject.get("time").getAsInt();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Error reading configuration file: " + e.getMessage());
                return 11111;
            }
        }
        reader.close();
        return n;
    }

    private static String loadCommandFromConfig(LevelAccessor world) {
        String string;
        File configFile = new File("config/oas_work/clear_lag.json");
        FileReader reader = new FileReader(configFile);
        try {
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            string = jsonObject.get("command").getAsString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Error reading configuration file: " + e.getMessage());
                return "kill @e";
            }
        }
        reader.close();
        return string;
    }
}

