/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.task;

import aztech.modern_industrialization.MITooltips;
import net.minecraft.network.chat.Component;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTaskFactory;
import net.swedz.extended_industrialization.machines.component.farmer.task.task.FertilizingFarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.task.HarvestingFarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.task.HydratingFarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.task.PlantingFarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.task.TillingFarmerTask;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public enum FarmerTaskType {
    TILLING(TillingFarmerTask::new, EIText.FARMER_TASK_TILLING, EIText.FARMER_TASK_TILLING_DESCRIPTION),
    HYDRATING(HydratingFarmerTask::new, EIText.FARMER_TASK_HYDRATING, EIText.FARMER_TASK_HYDRATING_DESCRIPTION),
    FERTLIZING(FertilizingFarmerTask::new, EIText.FARMER_TASK_FERTILIZING, EIText.FARMER_TASK_FERTILIZING_DESCRIPTION),
    HARVESTING(HarvestingFarmerTask::new, EIText.FARMER_TASK_HARVESTING, EIText.FARMER_TASK_HARVESTING_DESCRIPTION),
    PLANTING(PlantingFarmerTask::new, EIText.FARMER_TASK_PLANTING, EIText.FARMER_TASK_PLANTING_DESCRIPTION);

    private final FarmerTaskFactory factory;
    private final EIText tooltipName;
    private final EIText tooltipDescription;

    private FarmerTaskType(FarmerTaskFactory factory, EIText tooltipName, EIText tooltipDescription) {
        this.factory = factory;
        this.tooltipName = tooltipName;
        this.tooltipDescription = tooltipDescription;
    }

    private FarmerTaskType(FarmerTaskFactory factory) {
        this(factory, null, null);
    }

    public FarmerTask create(FarmerComponent component) {
        return this.factory.create(component);
    }

    public Component tooltip() {
        return this.tooltipName == null || this.tooltipDescription == null ? null : MICompatibleTextLine.line((TranslatableTextEnum)EIText.FARMER_TASK).arg((Object)this.tooltipName.text().setStyle(MITooltips.NUMBER_TEXT)).arg((Object)this.tooltipDescription.text());
    }
}

