/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.task.task;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.Simulation;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.datamap.FertilizerPotency;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerBlock;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerTile;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTaskType;
import net.swedz.extended_industrialization.network.packet.FarmerFertilizeBlockPacket;
import net.swedz.tesseract.neoforge.compat.mi.helper.MachineInventoryHelper;

public final class FertilizingFarmerTask
extends FarmerTask {
    private int fertilizerTickRate;
    private int fertilizerTicks;

    public FertilizingFarmerTask(FarmerComponent component) {
        super(FarmerTaskType.FERTLIZING, component);
    }

    private static boolean tryConsume(MultiblockInventoryComponent inventory, Fluid fluid, long amount, Simulation simulation) {
        return MachineInventoryHelper.consumeFluid((List)inventory.getFluidInputs(), (Fluid)fluid, (long)amount, (Simulation)simulation) == amount;
    }

    private static FertilizerPotency tryConsumeFertilizer(MultiblockInventoryComponent inventory, Simulation simulation) {
        for (ConfigurableFluidStack fluidInput : inventory.getFluidInputs()) {
            Fluid fluid = ((FluidVariant)fluidInput.getResource()).getFluid();
            FertilizerPotency potency = FertilizerPotency.getFor(fluid);
            if (potency == null || !FertilizingFarmerTask.tryConsume(inventory, fluid, potency.mbToConsumePerFertilizerTick(), simulation)) continue;
            return potency;
        }
        return null;
    }

    @Override
    protected boolean run() {
        FertilizerPotency potency;
        if ((this.fertilizerTicks <= 0 || this.fertilizerTickRate <= 0) && (potency = FertilizingFarmerTask.tryConsumeFertilizer(this.inventory, Simulation.ACT)) != null) {
            this.fertilizerTickRate = potency.tickRate();
            this.fertilizerTicks = 1;
        }
        if (this.fertilizerTicks > 0 && this.fertilizerTickRate > 0 && this.processTick % this.fertilizerTickRate == 0) {
            List<FarmerBlock> crops = this.blockMap.tiles().stream().map(FarmerTile::crop).filter(cropBlock -> cropBlock.state(this.level).isRandomlyTicking()).toList();
            if (crops.isEmpty()) {
                return false;
            }
            FarmerBlock crop = crops.get(this.level.getRandom().nextInt(crops.size()));
            BlockPos pos = crop.pos();
            BlockState state = crop.state(this.level);
            int randomTicks = 0;
            BlockState modifiedState = state;
            do {
                modifiedState.randomTick((ServerLevel)this.level, pos, this.level.getRandom());
                modifiedState = this.level.getBlockState(pos);
            } while (++randomTicks < EI.config().farmerFertilizerMaxRandomTicks() && modifiedState.isRandomlyTicking());
            new FarmerFertilizeBlockPacket(pos).broadcastToClients((ServerLevel)this.level, (Vec3i)pos, 32.0);
            --this.fertilizerTicks;
            if (this.operations.operate()) {
                return true;
            }
        }
        return this.operations.didOperate();
    }

    @Override
    public void writeNbt(CompoundTag tag) {
        tag.putInt("fertilizer_tick_rate", this.fertilizerTickRate);
        tag.putInt("fertilizer_ticks", this.fertilizerTicks);
    }

    @Override
    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
        this.fertilizerTickRate = tag.getInt("fertilizer_tick_rate");
        this.fertilizerTicks = tag.getInt("fertilizer_ticks");
    }
}

