/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import net.swedz.extended_industrialization.EIArmorMaterials;
import net.swedz.extended_industrialization.EIBlocks;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.extended_industrialization.EIConfig;
import net.swedz.extended_industrialization.EICreativeTabs;
import net.swedz.extended_industrialization.EIDataMaps;
import net.swedz.extended_industrialization.EIEntities;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EILocalizedListeners;
import net.swedz.extended_industrialization.EILootModifiers;
import net.swedz.extended_industrialization.EIRecipeTypes;
import net.swedz.extended_industrialization.EISounds;
import net.swedz.extended_industrialization.datagen.DatagenDelegator;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.LargeElectricFurnaceBlockEntity;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.teslatower.TeslaTowerBlockEntity;
import net.swedz.extended_industrialization.machines.guicomponent.EIModularSlotPanelSlots;
import net.swedz.extended_industrialization.material.EIMaterialRegistry;
import net.swedz.extended_industrialization.network.EIPackets;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.api.MCIdentifiable;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.compat.mi.TesseractMI;
import net.swedz.tesseract.neoforge.config.ConfigManager;
import net.swedz.tesseract.neoforge.registry.RegisteredObjectHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="extended_industrialization")
public final class EI {
    public static final String ID = "extended_industrialization";
    public static final String NAME = "Extended Industrialization";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Extended Industrialization");
    private static EIConfig CONFIG;

    public static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)name);
    }

    public static Set<MCIdentifiable> getAllIdentifiables() {
        HashSet identifiables = Sets.newHashSet();
        identifiables.addAll(EIItems.values());
        identifiables.addAll(EIBlocks.values());
        identifiables.addAll(EIFluids.values());
        return identifiables;
    }

    public EI(IEventBus bus, ModContainer container) {
        EI.setupConfig(bus, container);
        EILocalizedListeners.INSTANCE.init();
        TesseractMI.init((String)ID);
        EIComponents.init(bus);
        EIArmorMaterials.init(bus);
        EIItems.init(bus);
        EIBlocks.init(bus);
        EIFluids.init(bus);
        EIEntities.init(bus);
        EILootModifiers.init(bus);
        EIMaterialRegistry.init();
        EICreativeTabs.init(bus);
        EIRecipeTypes.init(bus);
        EISounds.init(bus);
        EIModularSlotPanelSlots.init();
        bus.register((Object)new DatagenDelegator());
        bus.addListener(FMLCommonSetupEvent.class, event -> {
            EIItems.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
            EIBlocks.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
            EIFluids.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
        });
        bus.addListener(RegisterCapabilitiesEvent.class, event -> CapabilitiesListeners.triggerAll((String)ID, (RegisterCapabilitiesEvent)event));
        bus.addListener(RegisterPayloadHandlersEvent.class, EIPackets::init);
        bus.addListener(RegisterDataMapTypesEvent.class, EIDataMaps::init);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, DataMapsUpdatedEvent.class, event -> event.ifRegistry(Registries.BLOCK, registry -> LargeElectricFurnaceBlockEntity.initTiers()));
        TeslaTowerBlockEntity.registerTieredShapes();
    }

    public static EIConfig config() {
        Assert.notNull((Object)CONFIG, (String)"Config not yet loaded");
        return CONFIG;
    }

    private static void setupConfig(IEventBus bus, ModContainer container) {
        ConfigManager manager = new ConfigManager().includeDefaultValueComments();
        manager.codecs().register(EIConfig.CableTierDamages.class, EIConfig.CableTierDamages.CODEC);
        CONFIG = (EIConfig)manager.build(EIConfig.class).register(container, ModConfig.Type.STARTUP).load().listenToLoad(bus).config();
    }
}

