/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.nanosuit;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.swedz.extended_industrialization.EIClientRenderTypes;
import net.swedz.extended_industrialization.client.nanosuit.NanoArmorModel;
import net.swedz.extended_industrialization.client.nanosuit.decorations.NanoSuitDecorationModel;
import net.swedz.extended_industrialization.item.nanosuit.NanoSuitArmorItem;

public final class NanoArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends HumanoidArmorLayer<T, M, NanoArmorModel<T>> {
    private final List<NanoSuitDecorationModel> decorations;

    public static RenderType renderType(boolean useQuantumShader, boolean stars, boolean cull, int layerIndex, NanoSuitArmorItem item, ResourceLocation texture, boolean isColored) {
        if (layerIndex == 1 && useQuantumShader && item.isQuantum()) {
            return EIClientRenderTypes.NANO_QUANTUM.apply(new EIClientRenderTypes.NanoQuantumState(texture, stars, 1.0f, 0.5f, cull));
        }
        return (cull ? EIClientRenderTypes.ARMOR_CUTOUT_CULL_WITH_TRANSPARENCY : EIClientRenderTypes.ARMOR_CUTOUT_NO_CULL_WITH_TRANSPARENCY).apply(texture, isColored);
    }

    public static RenderType armorRenderType(int layerIndex, NanoSuitArmorItem item, ResourceLocation texture, boolean isColored) {
        return NanoArmorLayer.renderType(true, true, false, layerIndex, item, texture, isColored);
    }

    public static RenderType decorationRenderType(int layerIndex, NanoSuitArmorItem item, ResourceLocation texture, boolean isColored) {
        return NanoArmorLayer.renderType(true, false, true, layerIndex, item, texture, isColored);
    }

    public NanoArmorLayer(RenderLayerParent<T, M> renderer, NanoArmorModel<T> innerModel, NanoArmorModel<T> outerModel, List<NanoSuitDecorationModel> decorations, ModelManager modelManager) {
        super(renderer, innerModel, outerModel, modelManager);
        this.decorations = decorations;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float headYaw, float headPitch) {
        this.renderArmorPiece(poseStack, bufferSource, entity, EquipmentSlot.CHEST, packedLight, (NanoArmorModel)this.getArmorModel(EquipmentSlot.CHEST), limbSwing, limbSwingAmount, partialTicks, ageInTicks, headYaw, headPitch);
        this.renderArmorPiece(poseStack, bufferSource, entity, EquipmentSlot.HEAD, packedLight, (NanoArmorModel)this.getArmorModel(EquipmentSlot.HEAD), limbSwing, limbSwingAmount, partialTicks, ageInTicks, headYaw, headPitch);
        this.renderArmorPiece(poseStack, bufferSource, entity, EquipmentSlot.LEGS, packedLight, (NanoArmorModel)this.getArmorModel(EquipmentSlot.LEGS), limbSwing, limbSwingAmount, partialTicks, ageInTicks, headYaw, headPitch);
        this.renderArmorPiece(poseStack, bufferSource, entity, EquipmentSlot.FEET, packedLight, (NanoArmorModel)this.getArmorModel(EquipmentSlot.FEET), limbSwing, limbSwingAmount, partialTicks, ageInTicks, headYaw, headPitch);
        this.renderArmorPieceDecorations(poseStack, bufferSource, entity, EquipmentSlot.HEAD, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, headYaw, headPitch);
        this.renderArmorPieceDecorations(poseStack, bufferSource, entity, EquipmentSlot.CHEST, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, headYaw, headPitch);
        this.renderArmorPieceDecorations(poseStack, bufferSource, entity, EquipmentSlot.LEGS, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, headYaw, headPitch);
        this.renderArmorPieceDecorations(poseStack, bufferSource, entity, EquipmentSlot.FEET, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, headYaw, headPitch);
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, T entity, EquipmentSlot slot, int packedLight, NanoArmorModel<T> model, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float headYaw, float headPitch) {
        NanoSuitArmorItem item;
        ItemStack stack = entity.getItemBySlot(slot);
        Item item2 = stack.getItem();
        if (item2 instanceof NanoSuitArmorItem && (item = (NanoSuitArmorItem)item2).getEquipmentSlot() == slot) {
            ((HumanoidModel)this.getParentModel()).copyPropertiesTo(model);
            this.setPartVisibility((HumanoidModel)model, slot);
            model.slot = slot;
            boolean usesInnerModel = this.usesInnerModel(slot);
            ArmorMaterial armorMaterial = (ArmorMaterial)item.getMaterial().value();
            IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)stack);
            int fallbackColor = extensions.getDefaultDyeColor(stack);
            for (int layerIndex = armorMaterial.layers().size() - 1; layerIndex >= 0; --layerIndex) {
                ArmorMaterial.Layer armorMaterialLayer = (ArmorMaterial.Layer)armorMaterial.layers().get(layerIndex);
                int layerColor = extensions.getArmorLayerTintColor(stack, entity, armorMaterialLayer, layerIndex, fallbackColor);
                if (layerColor == 0) continue;
                boolean isColored = layerColor != -1;
                ResourceLocation texture = ClientHooks.getArmorTexture(entity, (ItemStack)stack, (ArmorMaterial.Layer)armorMaterialLayer, (boolean)usesInnerModel, (EquipmentSlot)slot);
                RenderType renderType = NanoArmorLayer.armorRenderType(layerIndex, item, texture, isColored);
                VertexConsumer buffer = bufferSource.getBuffer(renderType);
                model.renderToBuffer(poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, layerColor);
            }
            ArmorTrim armorTrim = (ArmorTrim)stack.get(DataComponents.TRIM);
            if (armorTrim != null) {
                this.renderTrim(item.getMaterial(), poseStack, bufferSource, packedLight, armorTrim, (Model)model, usesInnerModel);
            }
            if (stack.hasFoil()) {
                this.renderGlint(poseStack, bufferSource, packedLight, (Model)model);
            }
        }
    }

    private void renderArmorPieceDecorations(PoseStack poseStack, MultiBufferSource bufferSource, T entity, EquipmentSlot slot, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float headYaw, float headPitch) {
        NanoSuitArmorItem item;
        ItemStack stack = entity.getItemBySlot(slot);
        Item item2 = stack.getItem();
        if (item2 instanceof NanoSuitArmorItem && (item = (NanoSuitArmorItem)item2).getEquipmentSlot() == slot) {
            for (NanoSuitDecorationModel decoration : this.decorations) {
                ((HumanoidModel)this.getParentModel()).copyPropertiesTo((HumanoidModel)decoration);
                boolean shouldRender = decoration.test(entity, slot, stack);
                decoration.setAllVisible(shouldRender);
                if (!shouldRender) continue;
                ArmorMaterial armorMaterial = (ArmorMaterial)item.getMaterial().value();
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)stack);
                int fallbackColor = extensions.getDefaultDyeColor(stack);
                for (int layerIndex = armorMaterial.layers().size() - 1; layerIndex >= 0; --layerIndex) {
                    ArmorMaterial.Layer armorMaterialLayer = (ArmorMaterial.Layer)armorMaterial.layers().get(layerIndex);
                    int layerColor = extensions.getArmorLayerTintColor(stack, entity, armorMaterialLayer, layerIndex, fallbackColor);
                    if (layerColor == 0) continue;
                    boolean isColored = layerColor != -1;
                    decoration.render(entity, slot, stack, item, poseStack, bufferSource, packedLight, armorMaterialLayer, layerIndex, layerColor, isColored);
                }
                if (!stack.hasFoil()) continue;
                this.renderGlint(poseStack, bufferSource, packedLight, (Model)decoration);
            }
        }
    }
}

