/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.items.FluidFuelItemHelper;
import aztech.modern_industrialization.items.diesel_tools.DieselToolItem;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.Tickable;
import com.google.common.collect.Lists;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.EITooltips;
import net.swedz.extended_industrialization.item.ElectricToolItem;
import net.swedz.extended_industrialization.item.SteamChainsawItem;
import net.swedz.extended_industrialization.machines.component.solar.SolarSunlightComponent;
import net.swedz.extended_industrialization.machines.component.solar.boiler.SolarBoilerCalcificationComponent;
import net.swedz.extended_industrialization.machines.guicomponent.solarefficiency.SolarEfficiencyBar;
import net.swedz.tesseract.neoforge.compat.mi.component.SteamProductionComponent;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public final class SolarBoilerMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    private static final int WATER_SLOT_X = 38;
    private static final int WATER_SLOT_Y = 32;
    private static final int OUTPUT_SLOT_X = 122;
    private static final int OUTPUT_SLOT_Y = 32;
    private static final int BURNING_PROGRESS_X = 120;
    private static final int BURNING_PROGRESS_Y = 50;
    private static final int SOLAR_EFFICIENCY_X = 38;
    private static final int SOLAR_EFFICIENCY_Y = 75;
    private final MIInventory inventory;
    private final boolean bronze;
    private final long maxEuProduction;
    private final SolarSunlightComponent sunlight;
    private final SolarBoilerCalcificationComponent calcification;
    private final SteamProductionComponent steamProduction;
    private final IsActiveComponent isActiveComponent;

    public SolarBoilerMachineBlockEntity(BEP bep, boolean bronze) {
        super(bep, new MachineGuiParameters.Builder(EI.id(bronze ? "bronze_solar_boiler" : "steel_solar_boiler"), true).backgroundHeight(180).build(), new OrientationComponent.Params(false, false, false));
        this.bronze = bronze;
        this.maxEuProduction = bronze ? 4L : 8L;
        int capacity = 1000 * (bronze ? 8 : 16);
        List<ConfigurableFluidStack> fluidStacks = List.of(ConfigurableFluidStack.standardInputSlot((long)capacity), ConfigurableFluidStack.lockedOutputSlot((long)capacity, (Fluid)MIFluids.STEAM.asFluid()));
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(38, 32).addSlot(122, 32).build();
        this.inventory = new MIInventory(List.of(), fluidStacks, new SlotPositions.Builder().build(), fluidPositions);
        this.sunlight = new SolarSunlightComponent(this);
        this.calcification = new SolarBoilerCalcificationComponent();
        this.steamProduction = new SteamProductionComponent(this.inventory.fluidStorage, List.of(Fluids.WATER, EIFluids.DISTILLED_WATER.asFluid()), MIFluids.STEAM.variant(), () -> (long)((float)this.maxEuProduction * this.getEfficiency(true)), () -> 16);
        this.isActiveComponent = new IsActiveComponent();
        this.registerGuiComponent(new GuiComponent.Server[]{new ProgressBar.Server(new ProgressBar.Parameters(120, 50, "furnace", true), () -> Float.valueOf(this.getEfficiency(false)))});
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = SolarEfficiencyBar.Server.calcification(new SolarEfficiencyBar.Parameters(38, 75), this.sunlight::canOperate, () -> (int)(this.getEfficiency(true) * 100.0f), () -> (int)(this.calcification.getCalcification() * 100.0f));
        this.registerGuiComponent(serverArray);
        this.registerComponents(new IComponent[]{this.inventory, this.sunlight, this.calcification, this.steamProduction, this.isActiveComponent});
    }

    public float getEfficiency(boolean includeCalficiation) {
        return includeCalficiation ? this.sunlight.getSolarEfficiency() * this.calcification.getEfficiency() : this.sunlight.getSolarEfficiency();
    }

    public MIInventory getInventory() {
        return this.inventory;
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.bronze ? MachineCasings.BRICKED_BRONZE : MachineCasings.BRICKED_STEEL);
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        boolean active = true;
        if (this.sunlight.canOperate()) {
            FluidVariant waterFluid = this.steamProduction.tryMakeSteam();
            if (waterFluid.isBlank()) {
                active = false;
            } else if (!waterFluid.isOf((Object)EIFluids.DISTILLED_WATER.asFluid())) {
                this.calcification.tick();
            }
        } else {
            active = false;
        }
        for (Direction direction : Direction.values()) {
            this.getInventory().autoExtractFluids(this.level, this.worldPosition, direction);
        }
        this.isActiveComponent.updateActive(active, (MachineBlockEntity)this);
        this.setChanged();
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemStack stack;
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction() && player != null && (stack = player.getItemInHand(hand)).is(ItemTags.AXES)) {
            boolean canUse;
            Item item = stack.getItem();
            Objects.requireNonNull(item);
            Item item2 = item;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SteamChainsawItem.class, DieselToolItem.class, ElectricToolItem.class}, (Object)item2, n)) {
                case 0: {
                    SteamChainsawItem steamChainsaw = (SteamChainsawItem)item2;
                    canUse = steamChainsaw.canUse(stack);
                    if (!canUse) break;
                    steamChainsaw.useFuel(stack, (LivingEntity)player);
                    break;
                }
                case 1: {
                    DieselToolItem dieselToolItem = (DieselToolItem)item2;
                    boolean bl = canUse = FluidFuelItemHelper.getAmount((ItemStack)stack) > 0;
                    if (!canUse) break;
                    FluidFuelItemHelper.decrement((ItemStack)stack);
                    break;
                }
                case 2: {
                    ElectricToolItem electricTool = (ElectricToolItem)item2;
                    boolean bl = canUse = electricTool.getStoredEnergy(stack) > 0L;
                    if (!canUse) break;
                    electricTool.tryUseEnergy(stack, 2048L);
                    break;
                }
                default: {
                    stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    canUse = true;
                }
            }
            if (canUse) {
                this.calcification.reset();
                this.level.playSound(null, this.worldPosition, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.level.levelEvent(null, 3005, this.worldPosition, 0);
                result = ItemInteractionResult.CONSUME;
            }
        }
        return result;
    }

    public List<Component> getTooltips() {
        ArrayList tooltips = Lists.newArrayList();
        tooltips.add(MICompatibleTextLine.line((MIText)MIText.MaxEuProductionSteam).arg((Object)this.maxEuProduction, MITooltips.EU_PER_TICK_PARSER).arg((Object)MIFluids.STEAM));
        tooltips.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.SOLAR_BOILER_CALCIFICATION).arg((Object)Float.valueOf(0.33f), EITooltips.PERCENTAGE_PARSER).arg((Object)EIFluids.DISTILLED_WATER.asFluid()));
        return tooltips;
    }
}

