/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.task.task;

import aztech.modern_industrialization.inventory.MIItemStorage;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.datamap.EnchantmentModule;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.farmer.ElectricFarmerBlockEntity;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.farmer.FarmerBlockEntity;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerBlock;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerTile;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestableBehavior;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestableBehaviorHolder;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestingContext;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTaskType;

public final class HarvestingFarmerTask
extends FarmerTask {
    private final HarvestableBehaviorHolder harvestingHandlers;
    private final Map<BlockPos, List<ItemStack>> cachedDrops = Maps.newHashMap();

    public HarvestingFarmerTask(FarmerComponent component) {
        super(FarmerTaskType.HARVESTING, component);
        this.harvestingHandlers = component.getHarvestableBehaviorHolder();
    }

    private boolean insertDrops(List<ItemStack> drops, boolean simulate) {
        try (Transaction transaction = Transaction.openRoot();){
            MIItemStorage itemOutput = new MIItemStorage(this.inventory.getItemOutputs());
            boolean success = true;
            for (ItemStack item : drops) {
                long inserted = itemOutput.insertAllSlot((TransferVariant)ItemVariant.of((ItemStack)item), (long)item.getCount(), (TransactionContext)transaction);
                if (inserted == (long)item.getCount() || item.is(EITags.Items.FARMER_VOIDABLE)) continue;
                success = false;
                break;
            }
            if (!simulate) {
                transaction.commit();
            }
            boolean bl = success;
            return bl;
        }
    }

    private List<ItemStack> sortDrops(List<ItemStack> drops) {
        drops.sort(Comparator.comparing(item -> item.is(EITags.Items.FARMER_VOIDABLE)));
        return drops;
    }

    private List<ItemStack> getDrops(HarvestingContext context, HarvestableBehavior handler) {
        BlockPos origin = context.pos();
        if (this.cachedDrops.containsKey(origin)) {
            List<ItemStack> drops = List.copyOf((Collection)this.cachedDrops.get(origin));
            if (!this.insertDrops(drops, true)) {
                return List.of();
            }
            this.cachedDrops.remove(origin);
            return this.sortDrops(handler.getDrops(context));
        }
        List<ItemStack> drops = this.sortDrops(handler.getDrops(context));
        if (drops.isEmpty()) {
            return drops;
        }
        if (!this.insertDrops(drops, true)) {
            this.cachedDrops.put(origin, drops);
            return List.of();
        }
        return drops;
    }

    private boolean harvestBlocks(FarmerBlock cropBlockEntry, HarvestingContext context, HarvestableBehavior handler) {
        BlockPos pos;
        int index;
        BlockPos origin = context.pos();
        List<BlockPos> blockPositions = handler.getBlocks(context);
        if (blockPositions.isEmpty()) {
            return false;
        }
        List<ItemStack> drops = this.getDrops(context, handler);
        if (drops.isEmpty()) {
            return false;
        }
        this.insertDrops(drops, false);
        BlockState[] oldStates = new BlockState[blockPositions.size()];
        BlockState[] newStates = new BlockState[blockPositions.size()];
        BlockState newOriginState = Blocks.AIR.defaultBlockState();
        for (index = 0; index < blockPositions.size(); ++index) {
            BlockState newState;
            pos = blockPositions.get(index);
            oldStates[index] = this.level.getBlockState(pos);
            newStates[index] = newState = this.level.getFluidState(pos).createLegacyBlock();
            if (pos.equals((Object)origin)) {
                newOriginState = newState;
            }
            this.level.setBlock(pos, newState, 4, 0);
        }
        for (index = 0; index < blockPositions.size(); ++index) {
            pos = blockPositions.get(index);
            BlockState oldState = oldStates[index];
            BlockState newState = newStates[index];
            this.markAndNotifyBlockWithoutOnBlockStateChange(pos, this.level.getChunkAt(pos), oldState, newState, 3, 512);
        }
        cropBlockEntry.updateState(newOriginState);
        handler.harvested(context);
        return true;
    }

    private void markAndNotifyBlockWithoutOnBlockStateChange(BlockPos pos, LevelChunk chunk, BlockState oldState, BlockState newState, int updateFlag, int updateLimit) {
        Block block = newState.getBlock();
        BlockState currentState = this.level.getBlockState(pos);
        if (currentState == newState) {
            if (oldState != currentState) {
                this.level.setBlocksDirty(pos, oldState, currentState);
            }
            if ((updateFlag & 2) != 0 && (!this.level.isClientSide() || (updateFlag & 4) == 0) && (this.level.isClientSide() || chunk.getFullStatus() != null && chunk.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING))) {
                this.level.sendBlockUpdated(pos, oldState, newState, updateFlag);
            }
            if ((updateFlag & 1) != 0) {
                this.level.blockUpdated(pos, oldState.getBlock());
                if (!this.level.isClientSide() && newState.hasAnalogOutputSignal()) {
                    this.level.updateNeighbourForOutputSignal(pos, block);
                }
            }
            if ((updateFlag & 0x10) == 0 && updateLimit > 0) {
                int flags = updateFlag & 0xFFFFFFDE;
                oldState.updateIndirectNeighbourShapes((LevelAccessor)this.level, pos, flags, updateLimit - 1);
                newState.updateNeighbourShapes((LevelAccessor)this.level, pos, flags, updateLimit - 1);
                newState.updateIndirectNeighbourShapes((LevelAccessor)this.level, pos, flags, updateLimit - 1);
            }
        }
    }

    private Optional<EnchantmentModule> getActiveEnchantment() {
        Optional<EnchantmentModule> optional;
        FarmerBlockEntity farmerBlockEntity = this.farmer.getMachine();
        if (farmerBlockEntity instanceof ElectricFarmerBlockEntity) {
            ElectricFarmerBlockEntity electric = (ElectricFarmerBlockEntity)farmerBlockEntity;
            optional = electric.getEnchantmentModuleComponent().getActiveEnchantment();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    protected boolean run() {
        for (FarmerTile tile : this.blockMap) {
            HarvestableBehavior handler;
            BlockState state;
            FarmerBlock crop = tile.crop();
            BlockPos pos = crop.pos();
            HarvestingContext context = new HarvestingContext(this.level, pos, state = crop.state(this.level), this.getActiveEnchantment(), this.farmer.getMachine().getHighestCableTier());
            Optional handlerOptional = this.harvestingHandlers.behavior(context);
            if (!handlerOptional.isPresent() || !(handler = (HarvestableBehavior)handlerOptional.get()).isFullyGrown(context) || !this.harvestBlocks(crop, context, handler) || !this.operations.operate()) continue;
            return true;
        }
        return this.operations.didOperate();
    }
}

