/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponent.teslanetwork;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiverState;
import net.swedz.tesseract.neoforge.api.WorldPos;

public final class TeslaNetworkBar {
    public static final ResourceLocation ID = EI.id("tesla_network_bar");

    public record SingingData(int note, long energyConsuming) implements Data
    {
        private static final char ZERO = '\u2080';
        private static final char ONE = '\u2081';
        private static final char TWO = '\u2082';
        private static final String[] READABLE_NOTES = new String[]{"F#\u2080", "G\u2080", "G#\u2080", "A\u2080", "A#\u2080", "B\u2080", "C\u2080", "C#\u2080", "D\u2080", "D#\u2080", "E\u2080", "F\u2080", "F#\u2081", "G\u2081", "G#\u2081", "A\u2081", "A#\u2081", "B\u2081", "C\u2081", "C#\u2081", "D\u2081", "D#\u2081", "E\u2081", "F\u2081", "F#\u2082"};

        public String getReadableNote() {
            return READABLE_NOTES[this.note];
        }

        @Override
        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeVarInt(2);
            buf.writeVarInt(this.note);
            buf.writeVarLong(this.energyConsuming);
        }

        @Override
        public int iconIndex() {
            return 6;
        }
    }

    public record ReceiverData(TeslaReceiverState state, Optional<WorldPos> linked, Optional<CableTier> networkCableTier) implements Data
    {
        @Override
        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeVarInt(1);
            buf.writeEnum((Enum)this.state);
            buf.writeOptional(this.linked, (StreamEncoder)WorldPos.STREAM_CODEC);
            if (this.linked.isPresent()) {
                buf.writeBoolean(this.networkCableTier.isPresent());
                this.networkCableTier.ifPresent(cableTier -> buf.writeUtf(cableTier.name));
            }
        }

        @Override
        public int iconIndex() {
            if (this.state.isFailure()) {
                return switch (this.state) {
                    case TeslaReceiverState.NO_LINK -> 0;
                    case TeslaReceiverState.UNLOADED_TRANSMITTER -> 3;
                    case TeslaReceiverState.MISMATCHING_VOLTAGE -> 4;
                    case TeslaReceiverState.TOO_FAR -> 5;
                    case TeslaReceiverState.UNDEFINED -> 2;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.state));
                };
            }
            return 1;
        }
    }

    public record TransmitterData(int receivers, long energyTransmitting, CableTier cableTier, long energyDrain, long energyConsuming) implements Data
    {
        @Override
        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeVarInt(0);
            buf.writeVarInt(this.receivers);
            buf.writeVarLong(this.energyTransmitting);
            buf.writeUtf(this.cableTier.name);
            buf.writeVarLong(this.energyDrain);
            buf.writeVarLong(this.energyConsuming);
        }

        @Override
        public int iconIndex() {
            return 1;
        }
    }

    public static interface Data {
        public void write(RegistryFriendlyByteBuf var1);

        public int iconIndex();
    }

    public record Parameters(int renderX, int renderY) {
    }

    public static final class Server
    implements GuiComponent.Server<Optional<Data>> {
        private final Parameters params;
        private final Supplier<Optional<Data>> data;

        public Server(Parameters params, Supplier<Optional<Data>> data) {
            this.params = params;
            this.data = data;
        }

        public Optional<Data> copyData() {
            return this.data.get();
        }

        public boolean needsSync(Optional<Data> cachedData) {
            return !cachedData.equals(this.copyData());
        }

        public void writeInitialData(RegistryFriendlyByteBuf buf) {
            buf.writeVarInt(this.params.renderX);
            buf.writeVarInt(this.params.renderY);
            this.writeCurrentData(buf);
        }

        public void writeCurrentData(RegistryFriendlyByteBuf buf) {
            Optional<Data> data = this.data.get();
            buf.writeBoolean(data.isPresent());
            data.ifPresent(d -> d.write(buf));
        }

        public ResourceLocation getId() {
            return ID;
        }
    }
}

