/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.model.tesla;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.IModelBuilder;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.client.model.tesla.TeslaBakedModel;
import net.swedz.tesseract.neoforge.api.Assert;

public final class TeslaUnbakedModel
implements IUnbakedGeometry<TeslaUnbakedModel> {
    public static final ResourceLocation LOADER_ID = EI.id("tesla");
    public static final IGeometryLoader<TeslaUnbakedModel> LOADER = (json, context) -> {
        Plasma plasma = json.has("plasma") ? Plasma.deserialize(json.getAsJsonObject("plasma"), context) : null;
        Arcs arcs = json.has("arcs") ? Arcs.deserialize(json.getAsJsonObject("arcs"), context) : null;
        return new TeslaUnbakedModel(plasma, arcs);
    };
    private final Plasma plasma;
    private final Arcs arcs;

    private static Vec3 convertToWorld(Vec3 machinePosition, Direction machineDirection, Vec3 position) {
        Vec3 rotatedPos = switch (machineDirection) {
            case Direction.NORTH -> new Vec3(-position.x(), position.y(), position.z());
            case Direction.SOUTH -> new Vec3(position.x(), position.y(), -position.z());
            case Direction.EAST -> new Vec3(-position.z(), position.y(), -position.x());
            case Direction.WEST -> new Vec3(position.z(), position.y(), position.x());
            default -> throw new IllegalArgumentException("Unsupported machine direction: %s".formatted(machineDirection.toString()));
        };
        return rotatedPos.add(machinePosition);
    }

    private static AABB convertToWorld(Vec3 machinePosition, Direction machineDirection, AABB box) {
        Vec3 min = TeslaUnbakedModel.convertToWorld(machinePosition, machineDirection, box.getMinPosition());
        Vec3 max = TeslaUnbakedModel.convertToWorld(machinePosition, machineDirection, box.getMaxPosition());
        return new AABB(min, max);
    }

    private TeslaUnbakedModel(Plasma plasma, Arcs arcs) {
        this.plasma = plasma;
        this.arcs = arcs;
    }

    private void addQuads(IGeometryBakingContext context, IModelBuilder<?> modelBuilder, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState) {
        IQuadTransformer postTransform = QuadTransformers.empty();
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            postTransform = UnbakedGeometryHelper.applyRootTransform((ModelState)modelState, (Transformation)rootTransform);
        }
        if (this.plasma != null) {
            for (BlockElement element : this.plasma.elements()) {
                for (Direction direction : element.faces.keySet()) {
                    BlockElementFace face = (BlockElementFace)element.faces.get(direction);
                    TextureAtlasSprite sprite = spriteGetter.apply(context.getMaterial(face.texture()));
                    BakedQuad quad = BlockModel.bakeFace((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)modelState);
                    postTransform.processInPlace(quad);
                    if (face.cullForDirection() == null) {
                        modelBuilder.addUnculledFace(quad);
                        continue;
                    }
                    modelBuilder.addCulledFace(modelState.getRotation().rotateTransform(face.cullForDirection()), quad);
                }
            }
        }
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        final ArrayList unculledFaces = Lists.newArrayList();
        final EnumMap culledFaces = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            culledFaces.put(direction, Lists.newArrayList());
        }
        IModelBuilder builder = new IModelBuilder(){

            public IModelBuilder addCulledFace(Direction facing, BakedQuad quad) {
                ((List)culledFaces.get(facing)).add(quad);
                return this;
            }

            public IModelBuilder addUnculledFace(BakedQuad quad) {
                unculledFaces.add(quad);
                return this;
            }

            public BakedModel build() {
                return new TeslaBakedModel(unculledFaces, culledFaces, TeslaUnbakedModel.this.plasma, TeslaUnbakedModel.this.arcs);
            }
        };
        this.addQuads(context, builder, baker, spriteGetter, modelState);
        return builder.build();
    }

    public record Plasma(List<BlockElement> elements, Vec3 offset, float scale, float speed, float textureScale) {
        private static Plasma deserialize(JsonObject json, JsonDeserializationContext context) {
            Assert.that((boolean)json.has("elements"), (String)"A tesla model's plasma must have an \"elements\" member.", JsonParseException::new);
            ArrayList elements = Lists.newArrayList();
            for (JsonElement element : GsonHelper.getAsJsonArray((JsonObject)json, (String)"elements")) {
                elements.add((BlockElement)context.deserialize(element, BlockElement.class));
            }
            Assert.that((boolean)json.has("offset"), (String)"A tesla model's plasma must have an \"offset\" member.", JsonParseException::new);
            Vec3 offset = (Vec3)context.deserialize(json.get("offset"), Vec3.class);
            Assert.that((boolean)json.has("scale"), (String)"A tesla model's plasma must have a \"scale\" member.", JsonParseException::new);
            float scale = json.get("scale").getAsFloat();
            Assert.that((scale > 0.0f ? 1 : 0) != 0, (String)"A tesla model's plasma must have a > 0 \"scale\" member.", JsonParseException::new);
            Assert.that((boolean)json.has("speed"), (String)"A tesla model's plasma must have a \"speed\" member.", JsonParseException::new);
            float speed = json.get("speed").getAsFloat();
            Assert.that((speed >= 0.0f ? 1 : 0) != 0, (String)"A tesla model's plasma must have a non-negative \"speed\" member.", JsonParseException::new);
            Assert.that((boolean)json.has("texture_scale"), (String)"A tesla model's plasma must have a \"texture_scale\" member.", JsonParseException::new);
            float textureScale = json.get("texture_scale").getAsFloat();
            Assert.that((textureScale > 0.0f ? 1 : 0) != 0, (String)"A tesla model's plasma must have a > 0 \"texture_scale\" member.", JsonParseException::new);
            return new Plasma(elements, offset, scale, speed, textureScale);
        }

        public Vec3 worldOffset(Vec3 machinePosition, Direction machineDirection) {
            return TeslaUnbakedModel.convertToWorld(machinePosition, machineDirection, this.offset);
        }
    }

    public record Arcs(Optional<ArcBounds> randomBoundsInclude, Optional<ArcBounds> randomBoundsExclude, int attachToNearbyEntitiesRange, List<Vec3> origins, float widthScale, float minVariance, float maxVariance, int duration, int count, int minSegments, int maxSegments, int segmentSplits) {
        public Arcs {
            Assert.that((randomBoundsInclude.isPresent() == randomBoundsExclude.isPresent() ? 1 : 0) != 0);
        }

        private static Arcs deserialize(JsonObject json, JsonDeserializationContext context) {
            Optional<ArcBounds> randomBoundsInclude = Optional.empty();
            Optional<ArcBounds> randomBoundsExclude = Optional.empty();
            if (json.has("random_bounds")) {
                JsonObject randomBoundsJson = json.getAsJsonObject("random_bounds");
                Assert.that((randomBoundsJson.has("include") && randomBoundsJson.has("exclude") ? 1 : 0) != 0, (String)"A tesla model's arc random bounds must have both an \"include\" and \"exclude\" member.", JsonParseException::new);
                randomBoundsInclude = Optional.of(ArcBounds.deserialize(randomBoundsJson.getAsJsonObject("include"), context));
                randomBoundsExclude = Optional.of(ArcBounds.deserialize(randomBoundsJson.getAsJsonObject("exclude"), context));
            }
            int attachToNearbyEntities = 0;
            if (json.has("attach_to_nearby_entities")) {
                attachToNearbyEntities = json.get("attach_to_nearby_entities").getAsInt();
                Assert.that((attachToNearbyEntities >= 0 ? 1 : 0) != 0, (String)"A tesla model's arcs must have a non-negative \"attach_to_nearby_entities\" member.", JsonParseException::new);
            }
            Assert.that((boolean)json.has("origins"), (String)"A tesla model's arcs must have an \"origins\" member.", JsonParseException::new);
            ArrayList origins = Lists.newArrayList();
            for (JsonElement element : GsonHelper.getAsJsonArray((JsonObject)json, (String)"origins")) {
                origins.add((Vec3)context.deserialize(element, Vec3.class));
            }
            Assert.that((boolean)json.has("width_scale"), (String)"A tesla model's arcs must have a \"width_scale\" member.", JsonParseException::new);
            float widthScale = json.get("width_scale").getAsFloat();
            Assert.that((boolean)json.has("min_variance"), (String)"A tesla model's arcs must have a \"min_variance\" member.", JsonParseException::new);
            float minVariance = json.get("min_variance").getAsFloat();
            Assert.that((boolean)json.has("max_variance"), (String)"A tesla model's arcs must have a \"max_variance\" member.", JsonParseException::new);
            float maxVariance = json.get("max_variance").getAsFloat();
            Assert.that((boolean)json.has("duration"), (String)"A tesla model's arcs must have a \"duration\" member.", JsonParseException::new);
            int duration = json.get("duration").getAsInt();
            Assert.that((duration >= 0 ? 1 : 0) != 0, (String)"A tesla model's arcs must have a non-negative \"duration\".", JsonParseException::new);
            Assert.that((attachToNearbyEntities == 0 || duration == 0 ? 1 : 0) != 0, (String)"A tesla model's arcs must have a \"duration\" = 0 when \"attach_to_nearby_entities\" is > 0.", JsonParseException::new);
            Assert.that((boolean)json.has("count"), (String)"A tesla model's arcs must have a \"count\" member.", JsonParseException::new);
            int count = json.get("count").getAsInt();
            Assert.that((count > 0 ? 1 : 0) != 0, (String)"A tesla model's arcs must have a > 0 \"count\" member.", JsonParseException::new);
            Assert.that((boolean)json.has("min_segments"), (String)"A tesla model's arcs must have a \"min_segments\" member.", JsonParseException::new);
            int minSegments = json.get("min_segments").getAsInt();
            Assert.that((minSegments > 0 ? 1 : 0) != 0, (String)"A tesla model's arcs must have a > 0 \"min_segments\" member.", JsonParseException::new);
            Assert.that((boolean)json.has("max_segments"), (String)"A tesla model's arcs must have a \"max_segments\" member.", JsonParseException::new);
            int maxSegments = json.get("max_segments").getAsInt();
            Assert.that((maxSegments > 0 ? 1 : 0) != 0, (String)"A tesla model's arcs must have a > 0 \"max_segments\" member.", JsonParseException::new);
            Assert.that((boolean)json.has("segment_splits"), (String)"A tesla model's arcs must have a \"segment_splits\" member.", JsonParseException::new);
            int segmentSplits = json.get("segment_splits").getAsInt();
            Assert.that((segmentSplits > 0 ? 1 : 0) != 0, (String)"A tesla model's arcs must have a > 0 \"segment_splits\" member.", JsonParseException::new);
            return new Arcs(randomBoundsInclude, randomBoundsExclude, attachToNearbyEntities, origins, widthScale, minVariance, maxVariance, duration, count, minSegments, maxSegments, segmentSplits);
        }

        public boolean hasRandomBounds() {
            return this.randomBoundsInclude.isPresent();
        }

        public AABB worldIncludeBounds(Vec3 machinePosition, Direction machineDirection) {
            return TeslaUnbakedModel.convertToWorld(machinePosition, machineDirection, this.randomBoundsInclude.orElseThrow().toAABB());
        }

        public AABB worldExcludeBounds(Vec3 machinePosition, Direction machineDirection) {
            return TeslaUnbakedModel.convertToWorld(machinePosition, machineDirection, this.randomBoundsExclude.orElseThrow().toAABB());
        }

        public Vec3 worldRandomPointInBounds(Random random, Vec3 machinePosition, Direction machineDirection) {
            double randomZ;
            double randomY;
            double randomX;
            Vec3 randomPos;
            Assert.that((boolean)this.hasRandomBounds());
            AABB include = this.worldIncludeBounds(machinePosition, machineDirection);
            AABB exclude = this.worldExcludeBounds(machinePosition, machineDirection);
            while (exclude.contains(randomPos = new Vec3(randomX = random.nextDouble(include.minX, include.maxX), randomY = random.nextDouble(include.minY, include.maxY), randomZ = random.nextDouble(include.minZ, include.maxZ)))) {
            }
            return randomPos;
        }

        public boolean attachesToNearbyEntities() {
            return this.attachToNearbyEntitiesRange > 0;
        }

        public AABB worldNearbyEntitiesBounds(Vec3 machinePosition, Direction machineDirection) {
            int range = this.attachToNearbyEntitiesRange;
            return TeslaUnbakedModel.convertToWorld(machinePosition, machineDirection, new AABB(new Vec3((double)(-range), (double)(-range), (double)(-range)).subtract(0.5, 0.5, 0.5), new Vec3((double)range, (double)range, (double)range).add(0.5, 0.5, 0.5)));
        }

        public List<Vec3> worldOrigins(Vec3 machinePosition, Direction machineDirection) {
            ArrayList converted = Lists.newArrayList();
            for (Vec3 origin : this.origins) {
                converted.add(TeslaUnbakedModel.convertToWorld(machinePosition, machineDirection, origin));
            }
            return Collections.unmodifiableList(converted);
        }

        public float randomVariance(Random random) {
            return this.minVariance == this.maxVariance ? this.minVariance : random.nextFloat(this.minVariance, this.maxVariance);
        }
    }

    public record ArcBounds(Vec3 min, Vec3 max) {
        private static ArcBounds deserialize(JsonObject json, JsonDeserializationContext context) {
            Assert.that((json.has("min") && json.has("max") ? 1 : 0) != 0, (String)"A tesla model's arc bounds must have both a \"min\" and \"max\" member.", JsonParseException::new);
            Vec3 min = (Vec3)context.deserialize(json.get("min"), Vec3.class);
            Vec3 max = (Vec3)context.deserialize(json.get("max"), Vec3.class);
            return new ArcBounds(min, max);
        }

        public AABB toAABB() {
            return new AABB(this.min, this.max);
        }
    }
}

