/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.api.energy.CableTier;
import com.google.common.collect.Lists;
import dev.technici4n.grandpower.api.ISimpleEnergyItem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.proxy.modslot.EIModSlotProxy;
import net.swedz.tesseract.neoforge.proxy.Proxies;

public final class RobotAutoFeederItem
extends Item
implements ISimpleEnergyItem {
    private static final long EAT_ENERGY_COST = 256L;
    private static final long ENERGY_CAPACITY = CableTier.LV.getMaxTransfer() * 256L;

    public RobotAutoFeederItem(Item.Properties properties) {
        super(properties.stacksTo(1).component(EIComponents.HIDE_BAR, (Object)false).component(MIComponents.ENERGY, (Object)0L));
    }

    public DataComponentType<Long> getEnergyComponent() {
        return (DataComponentType)MIComponents.ENERGY.get();
    }

    public long getEnergyCapacity(ItemStack stack) {
        return ENERGY_CAPACITY;
    }

    public long getEnergyMaxInput(ItemStack stack) {
        return ENERGY_CAPACITY;
    }

    public long getEnergyMaxOutput(ItemStack stack) {
        return ENERGY_CAPACITY;
    }

    public boolean hasEnergy(ItemStack stack) {
        return this.getStoredEnergy(stack) > 0L;
    }

    public boolean isBarVisible(ItemStack stack) {
        return (Boolean)stack.getOrDefault(EIComponents.HIDE_BAR, (Object)false) == false;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.round((double)this.getStoredEnergy(stack) / (double)ENERGY_CAPACITY * 13.0);
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF0000;
    }

    private ItemStack extractCannedFood(Player player) {
        ArrayList contents = Lists.newArrayList();
        contents.addAll(player.getInventory().items);
        contents.addAll(((EIModSlotProxy)Proxies.get(EIModSlotProxy.class)).getContents(player, stack -> true));
        for (ItemStack stack2 : contents) {
            if (stack2.is(EIItems.CANNED_FOOD.asItem())) {
                ItemStack extracted = stack2.copyWithCount(1);
                stack2.consume(1, (LivingEntity)player);
                return extracted;
            }
            IItemHandler capability = (IItemHandler)stack2.getCapability(Capabilities.ItemHandler.ITEM);
            if (capability == null) continue;
            for (int slot = 0; slot < capability.getSlots(); ++slot) {
                ItemStack innerStack = capability.getStackInSlot(slot);
                if (!innerStack.is(EIItems.CANNED_FOOD.asItem())) continue;
                return capability.extractItem(slot, 1, false);
            }
        }
        return ItemStack.EMPTY;
    }

    private ItemStack eat(Player player, ItemStack stack, FoodProperties food) {
        Level level = player.level();
        player.getFoodData().eat(food);
        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), player.getEatingSound(stack), SoundSource.NEUTRAL, 1.0f, 1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
        player.addEatEffect(food);
        stack.consume(1, (LivingEntity)player);
        player.gameEvent((Holder)GameEvent.EAT);
        Optional container = food.usingConvertsTo();
        if (container.isPresent() && !player.hasInfiniteMaterials()) {
            return ((ItemStack)container.get()).copy();
        }
        return ItemStack.EMPTY;
    }

    private ItemStack eat(Player player, ItemStack stack) {
        FoodProperties food = stack.getFoodProperties((LivingEntity)player);
        return food == null ? ItemStack.EMPTY : this.eat(player, stack, food);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ItemStack cannedFoodStack;
        Player player;
        if (level.isClientSide() || level.getGameTime() % 20L != 0L) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).getFoodData().getFoodLevel() <= 18 && this.hasEnergy(stack) && !(cannedFoodStack = this.extractCannedFood(player)).isEmpty()) {
            ItemStack container = this.eat(player, cannedFoodStack);
            if (!container.isEmpty() && !player.getInventory().add(container)) {
                player.drop(container, false);
            }
            this.tryUseEnergy(stack, 256L);
        }
    }
}

