/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.fluidharvesting;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.swedz.extended_industrialization.machines.blockentity.fluidharvesting.FluidHarvestingMachineBlockEntity;
import net.swedz.extended_industrialization.machines.component.fluidharvesting.FluidHarvestingBehaviorCreator;
import net.swedz.tesseract.neoforge.compat.mi.helper.EuConsumerBehavior;

public final class ElectricFluidHarvestingMachineBlockEntity
extends FluidHarvestingMachineBlockEntity
implements EnergyComponentHolder {
    private final MIInventory inventory;
    private final EnergyComponent energy;
    private final MIEnergyStorage insertable;
    private final RedstoneControlComponent redstoneControl;

    public ElectricFluidHarvestingMachineBlockEntity(BEP bep, ResourceLocation blockName, long euCost, FluidHarvestingBehaviorCreator behaviorCreator, long capacity, FluidLike fluid) {
        super(bep, blockName, euCost, behaviorCreator);
        List<ConfigurableFluidStack> fluidStacks = Collections.singletonList(ConfigurableFluidStack.lockedOutputSlot((long)capacity, (Fluid)fluid.asFluid()));
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(110, 30).build();
        this.inventory = new MIInventory(Collections.emptyList(), fluidStacks, SlotPositions.empty(), fluidPositions);
        this.energy = new EnergyComponent((BlockEntity)this, 3200L);
        this.insertable = this.energy.buildInsertable(tier -> tier == CableTier.LV);
        this.redstoneControl = new RedstoneControlComponent();
        this.registerComponents(new IComponent[]{this.inventory, this.energy, this.redstoneControl});
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(new EnergyBar.Parameters(18, 29), () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl)});
    }

    @Override
    protected EuConsumerBehavior createEuConsumerBehavior() {
        return EuConsumerBehavior.electric((MachineBlockEntity)this, (EnergyComponent)this.energy, (RedstoneControlComponent)this.redstoneControl);
    }

    @Override
    public boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this);
    }

    public MIInventory getInventory() {
        return this.inventory;
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> ((ElectricFluidHarvestingMachineBlockEntity)be).insertable));
    }
}

