/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.multiblock;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.HatchTypes;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.machines.component.craft.processingarray.ProcessingArrayMachineComponent;
import net.swedz.extended_industrialization.machines.guicomponent.processingarraymachineslot.ProcessingArrayMachineSlot;
import net.swedz.tesseract.neoforge.compat.mi.TesseractMITooltips;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformer;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformers;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied.AbstractElectricMultipliedCraftingMultiblockBlockEntity;
import net.swedz.tesseract.neoforge.compat.mi.machine.multiblock.member.PredicateSimpleMember;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public final class ProcessingArrayBlockEntity
extends AbstractElectricMultipliedCraftingMultiblockBlockEntity {
    private final ProcessingArrayMachineComponent machines;
    private static final int MAX_MACHINES = 64;
    private static final int SPLIT = 4;
    private static final int BASE_MACHINES = 8;
    private static final int MULT_MACHINES = 2;
    private static final ShapeTemplate[] SHAPE_TEMPLATES = new ShapeTemplate[4];

    public ProcessingArrayBlockEntity(BEP bep) {
        super(bep, EI.id("processing_array"), SHAPE_TEMPLATES, MachineTier.LV);
        if (!EI.config().allowUpgradesInProcessingArray()) {
            SlotPanel.Server slotPanel = (SlotPanel.Server)this.guiComponents.get(SlotPanel.Server.class);
            if (slotPanel != null) {
                this.guiComponents.unregister((Object[])new GuiComponent.Server[]{slotPanel});
            }
            this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl).withOverdrive(this.overdrive)});
        }
        this.machines = new ProcessingArrayMachineComponent();
        this.registerComponents(new IComponent[]{this.machines});
        this.registerGuiComponent(new GuiComponent.Server[]{new ProcessingArrayMachineSlot.Server((MachineBlockEntity)this, () -> this.getMachineStackSize(this.activeShape.getActiveShapeIndex()), this.machines)});
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        ShapeSelection.LineInfo[] lineInfoArray = new ShapeSelection.LineInfo[1];
        lineInfoArray[0] = new ShapeSelection.LineInfo(4, IntStream.range(0, 4).map(this::getMachineStackSize).mapToObj(xva$0 -> EIText.PROCESSING_ARRAY_SIZE.text(new Object[]{xva$0})).toList(), false);
        serverArray[0] = new ShapeSelection.Server(new ShapeSelection.Behavior(){

            public void handleClick(int line, int delta) {
                int newShapeIndex = Mth.clamp((int)(ProcessingArrayBlockEntity.this.activeShape.getActiveShapeIndex() + delta), (int)0, (int)(SHAPE_TEMPLATES.length - 1));
                int newMachineStackSize = ProcessingArrayBlockEntity.this.getMachineStackSize(newShapeIndex);
                if (newMachineStackSize < ProcessingArrayBlockEntity.this.machines.getMachines().getCount()) {
                    return;
                }
                ProcessingArrayBlockEntity.this.activeShape.incrementShape((MultiblockMachineBlockEntity)ProcessingArrayBlockEntity.this, delta);
            }

            public int getCurrentIndex(int line) {
                return ProcessingArrayBlockEntity.this.activeShape.getActiveShapeIndex();
            }
        }, lineInfoArray);
        this.registerGuiComponent(serverArray);
    }

    public MachineRecipeType getRecipeType() {
        return this.machines.getMachineRecipeType();
    }

    public int getMaxMultiplier() {
        return this.machines.getMachineCount();
    }

    public EuCostTransformer getEuCostTransformer() {
        return EuCostTransformers.percentage(() -> Float.valueOf((float)EI.config().batchingMachines().processingArrayEU()));
    }

    private int getMachineStackSize(int sizeIndex) {
        return (int)(8.0 * Math.pow(2.0, sizeIndex));
    }

    public List<Component> getTooltips() {
        ArrayList lines = Lists.newArrayList();
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.PROCESSING_ARRAY_RECIPE));
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.PROCESSING_ARRAY_BATCH_SIZE));
        if (EI.config().batchingMachines().processingArrayEU() != 1.0) {
            lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.PROCESSING_ARRAY_EU_COST_MULTIPLIER).arg((Object)this.getEuCostTransformer(), TesseractMITooltips.EU_COST_TRANSFORMER_PARSER));
        }
        return lines;
    }

    public static void registerReiShapes() {
        int index = 0;
        for (ShapeTemplate shapeTemplate : SHAPE_TEMPLATES) {
            ReiMachineRecipes.registerMultiblockShape((ResourceLocation)EI.id("processing_array"), (ShapeTemplate)shapeTemplate, (String)("" + index));
            ++index;
        }
    }

    static {
        SimpleMember casing = SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"clean_stainless_steel_machine_casing"))));
        SimpleMember pipe = SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"stainless_steel_machine_casing_pipe"))));
        PredicateSimpleMember glass = new PredicateSimpleMember(state -> state.is(EITags.blockCommon("glass_blocks")), Blocks.GLASS);
        HatchFlags front = new HatchFlags.Builder().with(HatchTypes.ENERGY_INPUT).build();
        HatchFlags top = new HatchFlags.Builder().with(new HatchType[]{HatchTypes.ITEM_INPUT, HatchTypes.FLUID_INPUT}).build();
        HatchFlags bottom = new HatchFlags.Builder().with(new HatchType[]{HatchTypes.ITEM_OUTPUT, HatchTypes.FLUID_OUTPUT}).build();
        int i = 0;
        int size = 3;
        for (int machines = 8; i < 4 && machines <= 64; machines *= 2) {
            ShapeTemplate.Builder builder = new ShapeTemplate.Builder(MachineCasings.CLEAN_STAINLESS_STEEL);
            for (int z = 0; z < size; ++z) {
                boolean isFront = z == 0;
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        boolean isGlass;
                        boolean isTop = y == 1;
                        boolean isBottom = y == -1;
                        boolean isCenter = x == 0 && y == 0;
                        boolean bl = isGlass = x != 0 && y == 0;
                        builder.add(x, y, z, (SimpleMember)(isCenter ? pipe : (isGlass ? glass : casing)), (HatchFlags)(isFront ? front : (isTop ? top : (isBottom ? bottom : null))));
                    }
                }
            }
            ProcessingArrayBlockEntity.SHAPE_TEMPLATES[i] = builder.build();
            ++i;
            size += 2;
        }
    }
}

