/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.chainer.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerLinks;
import net.swedz.extended_industrialization.machines.component.chainer.handler.SlotChainerHandler;
import net.swedz.extended_industrialization.machines.component.chainer.wrapper.SlotInventoryWrapper;

public final class ChainerFluidHandler
extends SlotChainerHandler<IFluidHandler>
implements IFluidHandler {
    public ChainerFluidHandler(ChainerLinks chainerLinks) {
        super(chainerLinks);
    }

    @Override
    public void invalidate() {
        ArrayList wrappers = Lists.newArrayList();
        int slots = 0;
        for (IFluidHandler handler : this.getMachineLinks().fluidHandlers()) {
            int handlerSlots = handler.getTanks();
            wrappers.add(new SlotInventoryWrapper<IFluidHandler>(handler, slots, handlerSlots));
            slots += handlerSlots;
        }
        this.wrappers = Collections.unmodifiableList(wrappers);
        this.wrappersSlotMap = Maps.newConcurrentMap();
        this.slots = slots;
    }

    public int getTanks() {
        return this.slots;
    }

    public FluidStack getFluidInTank(int tank) {
        SlotInventoryWrapper wrapper = this.getWrapper(tank);
        return wrapper != null ? ((IFluidHandler)wrapper.handler()).getFluidInTank(wrapper.toLocalSlot(tank)) : FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        SlotInventoryWrapper wrapper = this.getWrapper(tank);
        return wrapper != null ? ((IFluidHandler)wrapper.handler()).getTankCapacity(wrapper.toLocalSlot(tank)) : 0;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        SlotInventoryWrapper wrapper = this.getWrapper(tank);
        return wrapper != null && ((IFluidHandler)wrapper.handler()).isFluidValid(wrapper.toLocalSlot(tank), stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.chainerLinks.doesAllowOperation()) {
            return 0;
        }
        ArrayList buckets = Lists.newArrayList();
        ArrayList shuffledWrappers = Lists.newArrayList((Iterable)this.wrappers);
        Collections.shuffle(shuffledWrappers);
        for (SlotInventoryWrapper wrapper : shuffledWrappers) {
            buckets.add(new Bucket(wrapper, ((IFluidHandler)wrapper.handler()).fill(resource, IFluidHandler.FluidAction.SIMULATE)));
        }
        buckets.sort(Comparator.comparingInt(bucket -> bucket.simulationResult));
        int amountFilled = 0;
        for (int index = 0; index < buckets.size(); ++index) {
            SlotInventoryWrapper<IFluidHandler> wrapper = ((Bucket)buckets.get((int)index)).wrapper;
            int remainingStorages = buckets.size() - index;
            int remainingAmountToInsert = resource.getAmount() - amountFilled;
            int amountToInsert = remainingAmountToInsert / remainingStorages;
            amountFilled += ((IFluidHandler)wrapper.handler()).fill(resource.copyWithAmount(amountToInsert), action);
        }
        return amountFilled;
    }

    private FluidStack drain(Fluid fluid, int maxAmount, IFluidHandler.FluidAction action) {
        if (!this.chainerLinks.doesAllowOperation()) {
            return FluidStack.EMPTY;
        }
        ArrayList buckets = Lists.newArrayList();
        ArrayList shuffledWrappers = Lists.newArrayList((Iterable)this.wrappers);
        Collections.shuffle(shuffledWrappers);
        for (SlotInventoryWrapper wrapper : shuffledWrappers) {
            FluidStack simulationResult;
            FluidStack fluidStack = simulationResult = fluid == null ? ((IFluidHandler)wrapper.handler()).drain(maxAmount, IFluidHandler.FluidAction.SIMULATE) : ((IFluidHandler)wrapper.handler()).drain(new FluidStack(fluid, maxAmount), IFluidHandler.FluidAction.SIMULATE);
            if (!simulationResult.isEmpty()) {
                fluid = simulationResult.getFluid();
            }
            buckets.add(new Bucket(wrapper, simulationResult.getAmount()));
        }
        if (fluid == null || fluid == Fluids.EMPTY) {
            return FluidStack.EMPTY;
        }
        buckets.sort(Comparator.comparingInt(bucket -> bucket.simulationResult));
        int amountTransferred = 0;
        for (int index = 0; index < buckets.size(); ++index) {
            SlotInventoryWrapper<IFluidHandler> wrapper = ((Bucket)buckets.get((int)index)).wrapper;
            int remainingStorages = buckets.size() - index;
            int remainingAmountToTransfer = maxAmount - amountTransferred;
            int amountToTansfer = remainingAmountToTransfer / remainingStorages;
            FluidStack transferred = ((IFluidHandler)wrapper.handler()).drain(new FluidStack(fluid, amountToTansfer), action);
            amountTransferred += transferred.getAmount();
        }
        return new FluidStack(fluid, amountTransferred);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(resource.getFluid(), resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(null, maxDrain, action);
    }

    private static final class Bucket {
        private final SlotInventoryWrapper<IFluidHandler> wrapper;
        private final int simulationResult;

        private Bucket(SlotInventoryWrapper<IFluidHandler> wrapper, int simulationResult) {
            this.wrapper = wrapper;
            this.simulationResult = simulationResult;
        }
    }
}

