/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.tesla.network;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetworkCache;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaTransferLimits;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiver;
import net.swedz.extended_industrialization.machines.component.tesla.network.transmitter.TeslaTransmitter;
import net.swedz.tesseract.neoforge.api.WorldPos;

public final class TeslaNetwork
implements MIEnergyStorage,
TeslaTransferLimits.Delegate {
    private final TeslaNetworkCache cache;
    private final WorldPos key;
    private final Set<TeslaReceiver> loadedReceivers = Sets.newHashSet();
    private final List<TeslaReceiver> receivers = Lists.newArrayList();
    private Optional<TeslaTransmitter> transmitter = Optional.empty();

    public TeslaNetwork(TeslaNetworkCache cache, WorldPos key) {
        this.cache = cache;
        this.key = key;
    }

    private void maybeForget() {
        if (this.transmitter.isEmpty() && this.loadedReceivers.isEmpty()) {
            this.cache.forget(this);
        }
    }

    public WorldPos key() {
        return this.key;
    }

    public boolean hasTransmitter() {
        return this.transmitter.isPresent();
    }

    public boolean isTransmitterLoaded() {
        return this.hasTransmitter() && this.getTransmitter().getPosition().isTicking();
    }

    public void loadTransmitter(TeslaTransmitter transmitter) {
        this.transmitter = Optional.of(transmitter);
        this.updateAll();
    }

    public void unloadTransmitter() {
        this.transmitter = Optional.empty();
        this.maybeForget();
    }

    public TeslaTransmitter getTransmitter() {
        return this.transmitter.orElseThrow();
    }

    @Override
    public TeslaTransferLimits getDelegateTransferLimits() {
        if (!this.isTransmitterLoaded()) {
            throw new IllegalStateException("Cannot get transfer limits from network without a loaded transmitter");
        }
        return this.getTransmitter();
    }

    public void updateAll() {
        for (TeslaReceiver receiver : this.loadedReceivers) {
            this.update(receiver);
        }
    }

    private void update(TeslaReceiver receiver) {
        if (this.isTransmitterLoaded() && (receiver.isMobile() || receiver.checkReceiveFrom(this).isSuccess())) {
            if (!this.receivers.contains(receiver)) {
                this.receivers.add(receiver);
            }
        } else {
            this.receivers.remove(receiver);
        }
    }

    public void add(TeslaReceiver receiver) {
        this.loadedReceivers.add(receiver);
        this.update(receiver);
    }

    public void remove(TeslaReceiver receiver) {
        this.loadedReceivers.remove(receiver);
        this.receivers.remove(receiver);
        this.maybeForget();
    }

    public int loadedReceiverCount() {
        return this.loadedReceivers.size();
    }

    public int receiverCount() {
        return this.receivers.size();
    }

    public boolean canExtract() {
        return this.hasTransmitter();
    }

    public boolean canReceive() {
        return true;
    }

    public long receive(long maxReceive, boolean simulate) {
        if (!this.isTransmitterLoaded()) {
            return 0L;
        }
        Collections.sort(this.receivers);
        long amountReceived = 0L;
        long remaining = maxReceive;
        for (TeslaReceiver receiver : this.receivers) {
            if (receiver.isMobile() && receiver.checkReceiveFrom(this).isFailure()) continue;
            long received = receiver.receiveEnergy(remaining, simulate);
            amountReceived += received;
            remaining -= received;
        }
        return amountReceived;
    }

    public long extract(long maxExtract, boolean simulate) {
        return this.getTransmitter().extractEnergy(maxExtract, simulate);
    }

    public long getAmount() {
        return this.receivers.stream().mapToLong(TeslaReceiver::getStoredEnergy).sum();
    }

    public long getCapacity() {
        return this.receivers.stream().mapToLong(TeslaReceiver::getEnergyCapacity).sum();
    }

    public boolean canConnect(CableTier cableTier) {
        return this.getCableTier() == cableTier;
    }
}

