/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.tesla.network;

import aztech.modern_industrialization.api.energy.CableTier;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.teslatower.TeslaTowerTier;

public interface TeslaTransferLimits {
    public static TeslaTransferLimits of(CableTier cableTier, TeslaTowerTier towerTier) {
        return TeslaTransferLimits.of(cableTier, towerTier.maxTransfer(), towerTier.maxDistance(), towerTier.drain());
    }

    public static TeslaTransferLimits of(final CableTier cableTier, final long maxTransfer, final int maxDistance, final long passiveDrain) {
        return new TeslaTransferLimits(){

            @Override
            public CableTier getCableTier() {
                return cableTier;
            }

            @Override
            public long getMaxTransfer() {
                return maxTransfer;
            }

            @Override
            public int getMaxDistance() {
                return maxDistance;
            }

            @Override
            public long getPassiveDrain() {
                return passiveDrain;
            }
        };
    }

    public CableTier getCableTier();

    public long getMaxTransfer();

    public int getMaxDistance();

    public long getPassiveDrain();

    public static interface Delegate
    extends TeslaTransferLimits {
        public TeslaTransferLimits getDelegateTransferLimits();

        @Override
        default public CableTier getCableTier() {
            return this.getDelegateTransferLimits().getCableTier();
        }

        @Override
        default public long getMaxTransfer() {
            return this.getDelegateTransferLimits().getMaxTransfer();
        }

        @Override
        default public int getMaxDistance() {
            return this.getDelegateTransferLimits().getMaxDistance();
        }

        @Override
        default public long getPassiveDrain() {
            return this.getDelegateTransferLimits().getPassiveDrain();
        }
    }
}

