/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.tesla.network.receiver;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiver;
import net.swedz.extended_industrialization.proxy.modslot.EIModSlotProxy;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.compat.mi.helper.ChargeInventoryHelper;
import net.swedz.tesseract.neoforge.proxy.Proxies;

public final class PlayerTeslaReceiver
implements TeslaReceiver {
    private final Player player;
    private final WorldPos networkKey;

    public PlayerTeslaReceiver(Player player, WorldPos networkKey) {
        this.player = player;
        this.networkKey = networkKey;
    }

    @Override
    public boolean isMobile() {
        return true;
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate) {
        Inventory inventory = this.player.getInventory();
        ArrayList items = Lists.newArrayList();
        items.addAll(inventory.armor);
        items.addAll(inventory.items);
        items.addAll(inventory.offhand);
        items.addAll(((EIModSlotProxy)Proxies.get(EIModSlotProxy.class)).getContents(this.player, stack -> stack.getCapability(EnergyApi.ITEM) != null));
        return ChargeInventoryHelper.charge((Collection)items, (long)maxReceive, (boolean)simulate);
    }

    @Override
    public long getStoredEnergy() {
        throw new UnsupportedOperationException("Cannot get stored energy for a player receiver");
    }

    @Override
    public long getEnergyCapacity() {
        throw new UnsupportedOperationException("Cannot get energy capacity for a player receiver");
    }

    @Override
    public boolean hasNetwork() {
        return true;
    }

    @Override
    public WorldPos getNetworkKey() {
        return this.networkKey;
    }

    @Override
    public void setNetwork(WorldPos key) {
        throw new UnsupportedOperationException("Cannot set network for a player receiver");
    }

    @Override
    public WorldPos getPosition() {
        return new WorldPos(this.player.level(), this.player.blockPosition());
    }

    @Override
    public WorldPos getSourcePosition() {
        return this.getPosition();
    }

    @Override
    public CableTier getCableTier() {
        throw new UnsupportedOperationException("Cannot get cable tier for a player receiver");
    }
}

