/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server.provider.recipes;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIBlocks;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.RecipesServerDatagenProvider;
import net.swedz.extended_industrialization.material.EIMaterials;
import net.swedz.tesseract.neoforge.compat.mi.material.MIMaterials;
import net.swedz.tesseract.neoforge.compat.mi.material.part.MIMaterialParts;
import net.swedz.tesseract.neoforge.compat.mi.recipe.MIMachineRecipeBuilder;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapedRecipeBuilder;

public final class CommonRecipesServerDatagenProvider
extends RecipesServerDatagenProvider {
    public CommonRecipesServerDatagenProvider(GatherDataEvent event) {
        super(event);
    }

    private static void addBasicCraftingRecipes(String path, String name, boolean assembler, ItemLike result, int resultCount, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        ShapedRecipeBuilder shapedRecipeBuilder = new ShapedRecipeBuilder();
        crafting.accept(shapedRecipeBuilder);
        shapedRecipeBuilder.output(result, resultCount);
        shapedRecipeBuilder.offerTo(output, EI.id(path + "/craft/" + name));
        if (assembler) {
            MIMachineRecipeBuilder.fromShapedToAssembler((ShapedRecipeBuilder)shapedRecipeBuilder).offerTo(output, EI.id(path + "/assembler/" + name));
        }
    }

    private static void components(RecipeOutput output) {
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("component", "netherite_rotary_blade", true, EIItems.NETHERITE_ROTARY_BLADE, 1, r -> r.define('N', EITags.itemCommon("dusts/netherite")).define('R', EITags.itemCommon("gears/stainless_steel")).pattern(" N ").pattern("NRN").pattern(" N "), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("component", "steel_combine", false, EIItems.STEEL_COMBINE, 1, r -> r.define('C', "modern_industrialization:steel_curved_plate").define('B', "modern_industrialization:steel_bolt").define('R', EITags.itemCommon("rods/steel")).pattern("CCC").pattern("BRB").pattern("CCC"), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("component/assembler", "steel_combine", MIMachineRecipeTypes.ASSEMBLER, 8, 200, b -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)b.addItemInput("modern_industrialization:steel_curved_plate", 6)).addItemInput(EITags.itemCommon("rods/steel"), 1)).addFluidInput((FluidLike)MIFluids.SOLDERING_ALLOY, 50)).addItemOutput(EIItems.STEEL_COMBINE, 1), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("component", "tin_can", true, EIItems.TIN_CAN, 2, r -> r.define('T', "modern_industrialization:tin_curved_plate").pattern("T").pattern("T"), output);
    }

    private static void photovoltaicCells(RecipeOutput output) {
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "lv", MIMachineRecipeTypes.PACKER, 4, 800, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput(EITags.itemCommon("plates/silver"), 2)).addItemInput("modern_industrialization:rubber_sheet", 4)).addItemOutput(EIItems.LV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "lv_synthetic_rubber", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput(EITags.itemCommon("plates/silver"), 2)).addFluidInput((FluidLike)MIFluids.SYNTHETIC_RUBBER, 20)).addItemOutput(EIItems.LV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "lv_styrene_rubber", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput(EITags.itemCommon("plates/silver"), 2)).addFluidInput((FluidLike)MIFluids.STYRENE_BUTADIENE_RUBBER, 4)).addItemOutput(EIItems.LV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "mv", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput("modern_industrialization:silicon_n_doped_plate", 1)).addItemInput(EITags.itemCommon("plates/silver"), 4)).addItemInput("modern_industrialization:silicon_p_doped_plate", 1)).addFluidInput((FluidLike)MIFluids.SYNTHETIC_RUBBER, 100)).addItemOutput(EIItems.MV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "mv_styrene_rubber", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput("modern_industrialization:silicon_n_doped_plate", 1)).addItemInput(EITags.itemCommon("plates/silver"), 4)).addItemInput("modern_industrialization:silicon_p_doped_plate", 1)).addFluidInput((FluidLike)MIFluids.STYRENE_BUTADIENE_RUBBER, 20)).addItemOutput(EIItems.MV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "hv", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput("modern_industrialization:silicon_wafer", 4)).addItemInput(EITags.itemCommon("plates/silver"), 8)).addFluidInput((FluidLike)MIFluids.SYNTHETIC_RUBBER, 200)).addFluidInput((FluidLike)MIFluids.POLYETHYLENE, 500)).addItemOutput(EIItems.HV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "hv_styrene_rubber", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput("modern_industrialization:silicon_wafer", 4)).addItemInput(EITags.itemCommon("plates/silver"), 8)).addFluidInput((FluidLike)MIFluids.STYRENE_BUTADIENE_RUBBER, 40)).addFluidInput((FluidLike)MIFluids.POLYETHYLENE, 500)).addItemOutput(EIItems.HV_PHOTOVOLTAIC_CELL, 1), output);
    }

    private static void nanoSuitPiece(String id, ItemLike baseArmor, int pieces, ItemLike result, Consumer<MIMachineRecipeBuilder> recipeBuilder, RecipeOutput output) {
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", id, MIMachineRecipeTypes.ASSEMBLER, 8, 200, builder -> {
            ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)builder.addItemInput(baseArmor, 1)).addItemInput(EITags.itemCommon("plates/carbon"), 4 * pieces)).addItemInput((ItemLike)MIItem.ELECTRONIC_CIRCUIT, 4)).addItemInput("modern_industrialization:silicon_battery", 2)).addItemInput((ItemLike)MIItem.LARGE_MOTOR, 4)).addFluidInput((FluidLike)MIFluids.POLYETHYLENE, 4000)).addFluidInput((FluidLike)MIFluids.NYLON, 2000)).addItemOutput(result, 1);
            if (recipeBuilder != null) {
                recipeBuilder.accept((MIMachineRecipeBuilder)builder);
            }
        }, output);
    }

    private static void nanoSuit(RecipeOutput output) {
        CommonRecipesServerDatagenProvider.nanoSuitPiece("nano_suit_helmet", (ItemLike)Items.NETHERITE_HELMET, 5, EIItems.NANO_HELMET, r -> ((MIMachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput((ItemLike)MIItem.REDSTONE_CONTROL_MODULE, 1), output);
        CommonRecipesServerDatagenProvider.nanoSuitPiece("nano_suit_chestplate", (ItemLike)Items.NETHERITE_CHESTPLATE, 8, EIItems.NANO_CHESTPLATE, null, output);
        CommonRecipesServerDatagenProvider.nanoSuitPiece("nano_suit_leggings", (ItemLike)Items.NETHERITE_LEGGINGS, 7, EIItems.NANO_LEGGINGS, r -> r.addItemInput((ItemLike)MIItem.REDSTONE_CONTROL_MODULE, 1), output);
        CommonRecipesServerDatagenProvider.nanoSuitPiece("nano_suit_boots", (ItemLike)Items.NETHERITE_BOOTS, 4, EIItems.NANO_BOOTS, r -> r.addItemInput((ItemLike)MIItem.REDSTONE_CONTROL_MODULE, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", "nano_suit_gravichestplate_upgrade", MIMachineRecipeTypes.PACKER, 32, 200, b -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)b.addItemInput(EIItems.NANO_CHESTPLATE, 1)).addItemInput((ItemLike)MIItem.GRAVICHESTPLATE, 1)).addItemOutput(EIItems.NANO_GRAVICHESTPLATE, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", "nano_suit_gravichestplate_downgrade", MIMachineRecipeTypes.UNPACKER, 32, 200, b -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)b.addItemInput(EIItems.NANO_GRAVICHESTPLATE, 1)).addItemOutput(EIItems.NANO_CHESTPLATE, 1)).addItemOutput((ItemLike)MIItem.GRAVICHESTPLATE, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", "nano_suit_helmet_quantum_upgrade", MIMachineRecipeTypes.PACKER, 1000000, 200, b -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)b.addItemInput(EIItems.NANO_HELMET, 1)).addItemInput((ItemLike)MIItem.QUANTUM_UPGRADE, 1)).addItemOutput(EIItems.NANO_QUANTUM_HELMET, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", "nano_suit_chestplate_quantum_upgrade", MIMachineRecipeTypes.PACKER, 1000000, 200, b -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)b.addItemInput(EIItems.NANO_CHESTPLATE, 1)).addItemInput((ItemLike)MIItem.QUANTUM_UPGRADE, 1)).addItemOutput(EIItems.NANO_QUANTUM_CHESTPLATE, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", "nano_suit_leggings_quantum_upgrade", MIMachineRecipeTypes.PACKER, 1000000, 200, b -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)b.addItemInput(EIItems.NANO_LEGGINGS, 1)).addItemInput((ItemLike)MIItem.QUANTUM_UPGRADE, 1)).addItemOutput(EIItems.NANO_QUANTUM_LEGGINGS, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", "nano_suit_boots_quantum_upgrade", MIMachineRecipeTypes.PACKER, 1000000, 200, b -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)b.addItemInput(EIItems.NANO_BOOTS, 1)).addItemInput((ItemLike)MIItem.QUANTUM_UPGRADE, 1)).addItemOutput(EIItems.NANO_QUANTUM_BOOTS, 1), output);
    }

    private static void tesla(RecipeOutput output) {
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "tesla_calibrator", true, EIItems.TESLA_CALIBRATOR, 1, r -> r.define('S', new ItemLike[]{MIMaterials.SILVER.get(MIMaterialParts.WIRE)}).define('T', new ItemLike[]{MIItem.TRANSISTOR}).define('G', EITags.itemCommon("glass_panes")).define('D', new ItemLike[]{MIItem.DIODE}).define('C', new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT}).pattern(" S ").pattern("TGT").pattern("DCD"), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "tesla_handheld_receiver", true, EIItems.TESLA_HANDHELD_RECEIVER, 1, r -> r.define('S', "%s:silver_tesla_top_load".formatted("extended_industrialization")).define('W', new ItemLike[]{EIMaterials.ANNEALED_COPPER.get(EIMaterials.Parts.TESLA_WINDING)}).define('T', new ItemLike[]{MIItem.TRANSISTOR}).define('D', new ItemLike[]{MIItem.DIODE}).define('C', new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT}).pattern("S  ").pattern("WTT").pattern("CDD"), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("upgrade", "tesla_interdimensional_upgrade", MIMachineRecipeTypes.ASSEMBLER, 32, 1200, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput("%s:superconductor_tesla_winding".formatted("extended_industrialization"), 8)).addItemInput((ItemLike)MIItem.HIGHLY_ADVANCED_UPGRADE, 4)).addItemInput((ItemLike)MIItem.PROCESSING_UNIT, 1)).addFluidInput((FluidLike)MIFluids.POLYVINYL_CHLORIDE, 1000)).addItemOutput(EIItems.TESLA_INTERDIMENSIONAL_UPGRADE, 1), output);
        new ShapedRecipeBuilder().output("%s:tesla_particle_generator".formatted("extended_industrialization"), 1).define('T', "%s:silver_tesla_top_load".formatted("extended_industrialization")).define('C', new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT}).pattern("T").pattern("C").offerTo(output, EI.id("craft/tesla_particle_generator"));
    }

    protected void buildRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        CommonRecipesServerDatagenProvider.addMachineRecipe("mixer", "mulch", MIMachineRecipeTypes.MIXER, 2, 100, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput((ItemLike)Items.DIRT, 1)).addItemInput((ItemLike)MIItem.WOOD_PULP, 6)).addItemOutput(EIItems.MULCH, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("macerator", "granite_dust", MIMachineRecipeTypes.MACERATOR, 2, 100, r -> ((MIMachineRecipeBuilder)r.addItemInput((ItemLike)Items.GRANITE, 1)).addItemOutput(EIItems.GRANITE_DUST, 4), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("compacting", "granite_from_dust", false, (ItemLike)Items.GRANITE, 1, r -> r.define('G', new ItemLike[]{EIItems.GRANITE_DUST}).pattern("GG").pattern("GG"), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("packer", "granite_from_dust", MIMachineRecipeTypes.PACKER, 2, 100, r -> ((MIMachineRecipeBuilder)r.addItemInput(EITags.itemCommon("dusts/granite"), 4)).addItemOutput(Items.GRANITE, 1), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("casing", "steel_plated_bricks", true, (ItemLike)EIBlocks.STEEL_PLATED_BRICKS.get().asItem(), 1, r -> r.define('S', new ItemLike[]{MIMaterials.STEEL.get(MIMaterialParts.PLATE)}).define('B', "modern_industrialization:fire_clay_bricks").pattern("SSS").pattern("SBS").pattern("SSS"), output);
        CommonRecipesServerDatagenProvider.components(output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("distillery", "distilled_water_from_water", MIMachineRecipeTypes.DISTILLERY, 8, 200, r -> ((MIMachineRecipeBuilder)r.addFluidInput((Fluid)Fluids.WATER, 1000)).addFluidOutput((FluidLike)EIFluids.DISTILLED_WATER, 500), output);
        CommonRecipesServerDatagenProvider.photovoltaicCells(output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "steam_chainsaw", false, EIItems.STEAM_CHAINSAW, 1, r -> r.define('F', new ItemLike[]{Items.FURNACE}).define('D', new ItemLike[]{Items.DIAMOND}).define('P', "modern_industrialization:iron_large_plate").define('C', EITags.itemCommon("gears/copper")).define('B', new ItemLike[]{Items.BUCKET}).pattern("FDD").pattern("PCD").pattern("BPF"), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "electric_chainsaw", false, EIItems.ELECTRIC_CHAINSAW, 1, r -> r.define('U', new ItemLike[]{MIItem.ADVANCED_UPGRADE}).define('R', new ItemLike[]{MIItem.RUBBER_SHEET}).define('B', new ItemLike[]{EIItems.NETHERITE_ROTARY_BLADE}).define('M', new ItemLike[]{MIItem.ADVANCED_MOTOR}).define('C', "modern_industrialization:aluminum_cable").pattern("URB").pattern("MBR").pattern("CMU"), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "electric_mining_drill", false, EIItems.ELECTRIC_MINING_DRILL, 1, r -> r.define('U', new ItemLike[]{MIItem.ADVANCED_UPGRADE}).define('R', new ItemLike[]{EIItems.NETHERITE_ROTARY_BLADE}).define('D', "modern_industrialization:stainless_steel_drill_head").define('M', new ItemLike[]{MIItem.ADVANCED_MOTOR}).define('L', new ItemLike[]{MIItem.LARGE_MOTOR}).define('C', "modern_industrialization:aluminum_cable").pattern("URD").pattern("MLR").pattern("CMU"), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", "nano_saber", MIMachineRecipeTypes.ASSEMBLER, 8, 200, builder -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)builder.addItemInput((ItemLike)Items.NETHERITE_SWORD, 1)).addItemInput(EITags.itemCommon("plates/carbon"), 4)).addItemInput(EITags.itemCommon("plates/stainless_steel"), 12)).addItemInput((ItemLike)MIItem.ELECTRONIC_CIRCUIT, 4)).addItemInput("modern_industrialization:silicon_battery", 2)).addItemInput((ItemLike)Items.NETHER_STAR, 1)).addItemInput((ItemLike)MIItem.LARGE_MOTOR, 2)).addItemInput((ItemLike)MIItem.REDSTONE_CONTROL_MODULE, 1)).addFluidInput((FluidLike)MIFluids.POLYETHYLENE, 4000)).addFluidInput((FluidLike)MIFluids.CRYOFLUID, 1000)).addItemOutput(EIItems.NANO_SABER, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", "nano_saber_quantum_upgrade", MIMachineRecipeTypes.PACKER, 1000000, 200, b -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)b.addItemInput(EIItems.NANO_SABER, 1)).addItemInput((ItemLike)MIItem.QUANTUM_UPGRADE, 1)).addItemOutput(EIItems.NANO_QUANTUM_SABER, 1), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "robot_auto_feeder", false, EIItems.ROBOT_AUTO_FEEDER, 1, r -> r.define('M', new ItemLike[]{MIItem.MOTOR}).define('B', "modern_industrialization:bronze_curved_plate").define('R', new ItemLike[]{MIItem.ROBOT_ARM}).define('b', "modern_industrialization:redstone_battery").define('C', "modern_industrialization:electronic_circuit").pattern("MBM").pattern("BRB").pattern("bCb"), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "machine_config_card", false, EIItems.MACHINE_CONFIG_CARD, 1, r -> r.define('G', EITags.itemCommon("glass_panes")).define('I', "modern_industrialization:inductor").define('C', "modern_industrialization:capacitor").define('M', "modern_industrialization:motor").define('A', "modern_industrialization:analog_circuit_board").pattern("GGG").pattern("ICI").pattern("MAM"), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "ultimate_drill", false, EIItems.ULTIMATE_LASER_DRILL, 1, r -> r.define('D', new ItemLike[]{EIItems.ELECTRIC_MINING_DRILL}).define('B', new ItemLike[]{EIItems.NETHERITE_ROTARY_BLADE}).define('C', new ItemLike[]{EIItems.ELECTRIC_CHAINSAW}).define('c', "modern_industrialization:cooling_cell").define('S', "modern_industrialization:superconductor_coil").define('U', "modern_industrialization:highly_advanced_upgrade").define('s', "modern_industrialization:superconductor_cable").pattern("DBC").pattern("cSc").pattern("UsU"), output);
        CommonRecipesServerDatagenProvider.nanoSuit(output);
        CommonRecipesServerDatagenProvider.tesla(output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("assembler", "silk_touch_module", MIMachineRecipeTypes.ASSEMBLER, 8, 200, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput("#c:plates/stainless_steel", 8)).addItemInput((ItemLike)MIItem.INVAR_ROTARY_BLADE, 2)).addItemInput((ItemLike)MIItem.ROBOT_ARM, 4)).addFluidInput((FluidLike)MIFluids.POLYETHYLENE, 1000)).addItemOutput(EIItems.SILK_TOUCH_MODULE, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("assembler", "looting_module", MIMachineRecipeTypes.ASSEMBLER, 8, 200, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput("#c:plates/stainless_steel", 8)).addItemInput(EIItems.NETHERITE_ROTARY_BLADE, 2)).addItemInput((ItemLike)MIItem.ROBOT_ARM, 4)).addFluidInput((FluidLike)MIFluids.POLYETHYLENE, 1000)).addItemOutput(EIItems.LOOTING_MODULE, 1), output);
    }
}

