/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.harvesting.harvestable;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestingContext;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.LootTableHarvestableBehavior;

public final class BushBlockHarvestable
implements LootTableHarvestableBehavior {
    private static final Map<BlockState, IntegerProperty> AGEABLE_BLOCKS;

    private static IntegerProperty getNamedIntegerProperty(BlockState state, String name) {
        for (Property property : state.getProperties()) {
            if (!property.getName().equals(name) || !(property instanceof IntegerProperty)) continue;
            IntegerProperty ageProperty = (IntegerProperty)property;
            return ageProperty;
        }
        return null;
    }

    public boolean matches(HarvestingContext context) {
        return context.state().getBlock() instanceof BushBlock && AGEABLE_BLOCKS.containsKey(context.state());
    }

    @Override
    public boolean isFullyGrown(HarvestingContext context) {
        IntegerProperty property = AGEABLE_BLOCKS.get(context.state());
        return property != null && (Integer)context.state().getValue((Property)property) == property.max;
    }

    @Override
    public List<BlockPos> getBlocks(HarvestingContext context) {
        return Lists.newArrayList((Object[])new BlockPos[]{context.pos()});
    }

    static {
        HashMap ageableBlocks = Maps.newHashMap();
        for (Block block : BuiltInRegistries.BLOCK) {
            BlockState defaultState;
            IntegerProperty ageProperty;
            if (!(block instanceof BushBlock) || (ageProperty = BushBlockHarvestable.getNamedIntegerProperty(defaultState = block.defaultBlockState(), "age")) == null || BushBlockHarvestable.getNamedIntegerProperty(defaultState, "stage") != null) continue;
            for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                ageableBlocks.put(state, ageProperty);
            }
        }
        AGEABLE_BLOCKS = Collections.unmodifiableMap(ageableBlocks);
    }
}

