/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.nanosuit;

import java.util.List;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.swedz.extended_industrialization.EI;

public final class NanoArmorModel<T extends LivingEntity>
extends HumanoidArmorModel<T> {
    public static final ModelLayerLocation INNER_LAYER = new ModelLayerLocation(EI.id("nano_armor"), "inner_armor");
    public static final ModelLayerLocation OUTER_LAYER = new ModelLayerLocation(EI.id("nano_armor"), "outer_armor");
    public EquipmentSlot slot;
    public ModelPart root;
    public ModelPart head;
    public ModelPart hat;
    public ModelPart body;
    public ModelPart leftArm;
    public ModelPart rightArm;
    public ModelPart leftLeg;
    public ModelPart rightLeg;

    public static LayerDefinition createLayer(CubeDeformation deformation) {
        MeshDefinition mesh = NanoArmorModel.createMesh((CubeDeformation)deformation, (float)0.0f);
        PartDefinition root = NanoArmorModel.createHumanoidAlias(mesh);
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation.extend(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.extend(-0.1f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.extend(-0.1f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    private static PartDefinition createHumanoidAlias(MeshDefinition mesh) {
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("hat", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("body", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("left_arm", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("right_arm", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("left_leg", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("right_leg", new CubeListBuilder(), PartPose.ZERO);
        return root;
    }

    public NanoArmorModel(ModelPart root) {
        super(root);
        this.root = root;
        this.head = root.getChild("head");
        this.hat = root.getChild("hat");
        this.body = root.getChild("body");
        this.leftArm = root.getChild("left_arm");
        this.rightArm = root.getChild("right_arm");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
    }

    protected Iterable<ModelPart> headParts() {
        return this.slot == EquipmentSlot.HEAD ? List.of(this.head, this.hat) : List.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        if (this.slot == EquipmentSlot.CHEST) {
            return List.of(this.body, this.leftArm, this.rightArm);
        }
        if (this.slot == EquipmentSlot.LEGS) {
            return List.of(this.body, this.leftLeg, this.rightLeg);
        }
        if (this.slot == EquipmentSlot.FEET) {
            return List.of(this.leftLeg, this.rightLeg);
        }
        return List.of();
    }
}

