/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer;

import aztech.modern_industrialization.inventory.ChangeListener;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.component.farmer.PlantableConfigurableItemStack;

public final class FarmerComponentPlantableStacks {
    private final FarmerComponent farmer;
    private final Map<ConfigurableItemStack, PlantableConfigurableItemStack> listeners = Maps.newHashMap();
    private final List<PlantableConfigurableItemStack> items = Lists.newArrayList();

    FarmerComponentPlantableStacks(FarmerComponent farmer) {
        this.farmer = farmer;
    }

    public FarmerComponent getFarmer() {
        return this.farmer;
    }

    public List<PlantableConfigurableItemStack> getItems() {
        return new ArrayList<PlantableConfigurableItemStack>(this.items);
    }

    public void update(List<ConfigurableItemStack> stacks) {
        PlantableConfigurableItemStack listener;
        for (ConfigurableItemStack stack : stacks) {
            listener = this.listeners.remove(stack);
            if (listener == null) continue;
            stack.removeListener((ChangeListener)listener);
        }
        this.listeners.clear();
        this.items.clear();
        for (ConfigurableItemStack stack : stacks) {
            listener = new PlantableConfigurableItemStack(this, stack);
            listener.listenAll(List.of(stack), null);
            this.listeners.put(stack, listener);
            this.items.add(listener);
            listener.onChange();
        }
    }
}

