/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item.nanosuit.ability;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.swedz.extended_industrialization.EIArmorMaterials;
import net.swedz.extended_industrialization.item.nanosuit.NanoSuitArmorItem;
import net.swedz.extended_industrialization.item.nanosuit.ability.NanoSuitGravichestplateAbility;
import net.swedz.extended_industrialization.item.nanosuit.ability.NanoSuitNightVisionAbility;
import net.swedz.extended_industrialization.item.nanosuit.ability.NanoSuitQuantumFlightAbility;
import net.swedz.extended_industrialization.item.nanosuit.ability.NanoSuitSpeedAbility;
import net.swedz.extended_industrialization.item.nanosuit.ability.NanoSuitStepAbility;

public interface NanoSuitAbility {
    public static final NanoSuitQuantumFlightAbility QUANTUM_FLIGHT = new NanoSuitQuantumFlightAbility();
    public static final NanoSuitGravichestplateAbility GRAVICHESTPLATE = new NanoSuitGravichestplateAbility();
    public static final NanoSuitNightVisionAbility NIGHT_VISION = new NanoSuitNightVisionAbility();
    public static final NanoSuitSpeedAbility SPEED = new NanoSuitSpeedAbility();
    public static final NanoSuitStepAbility STEP = new NanoSuitStepAbility();

    default public Rarity rarity() {
        return Rarity.UNCOMMON;
    }

    public ArmorItem.Type armorType();

    default public EquipmentSlot equipmentSlot() {
        return this.armorType().getSlot();
    }

    default public EquipmentSlotGroup equipmentSlotGroup() {
        return EquipmentSlotGroup.bySlot((EquipmentSlot)this.equipmentSlot());
    }

    default public long overrideEnergyCapacity() {
        return 0L;
    }

    default public int overrideDefaultColor() {
        return EIArmorMaterials.NANO_COLOR;
    }

    default public ItemAttributeModifiers getModifiedDefaultAttributeModifiers(NanoSuitArmorItem item, ItemStack stack, ItemAttributeModifiers modifiers) {
        return modifiers;
    }

    default public Optional<List<Component>> getTooltipLines(NanoSuitArmorItem item, ItemStack stack) {
        return Optional.empty();
    }

    default public List<Component> getHelpTooltipLines(NanoSuitArmorItem item, ItemStack stack) {
        return List.of();
    }

    default public void onActivationChange(NanoSuitArmorItem item, Player player, ItemStack stack, boolean activated) {
    }

    default public void tick(NanoSuitArmorItem item, LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
    }

    default public void onUnequip(NanoSuitArmorItem item, LivingEntity entity, EquipmentSlot slot, ItemStack fromStack, ItemStack toStack) {
    }
}

