/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.task;

import net.minecraft.network.chat.Component;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTaskFactory;
import net.swedz.extended_industrialization.machines.component.farmer.task.task.FertilizingFarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.task.HarvestingFarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.task.HydratingFarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.task.PlantingFarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.task.TillingFarmerTask;

public enum FarmerTaskType {
    TILLING(TillingFarmerTask::new, (Component)EI.text().farmerTaskTilling(), (Component)EI.text().farmerTaskTillingDescription()),
    HYDRATING(HydratingFarmerTask::new, (Component)EI.text().farmerTaskHydrating(), (Component)EI.text().farmerTaskHydratingDescription()),
    FERTLIZING(FertilizingFarmerTask::new, (Component)EI.text().farmerTaskFertilizing(), (Component)EI.text().farmerTaskFertilizingDescription()),
    HARVESTING(HarvestingFarmerTask::new, (Component)EI.text().farmerTaskHarvesting(), (Component)EI.text().farmerTaskHarvestingDescription()),
    PLANTING(PlantingFarmerTask::new, (Component)EI.text().farmerTaskPlanting(), (Component)EI.text().farmerTaskPlantingDescription());

    private final FarmerTaskFactory factory;
    private final Component tooltipName;
    private final Component tooltipDescription;

    private FarmerTaskType(FarmerTaskFactory factory, Component tooltipName, Component tooltipDescription) {
        this.factory = factory;
        this.tooltipName = tooltipName;
        this.tooltipDescription = tooltipDescription;
    }

    private FarmerTaskType(FarmerTaskFactory factory) {
        this(factory, null, null);
    }

    public FarmerTask create(FarmerComponent component) {
        return this.factory.create(component);
    }

    public Component tooltip() {
        return this.tooltipName == null || this.tooltipDescription == null ? null : EI.text().farmerTask(this.tooltipName, this.tooltipDescription);
    }
}

