/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.distantfriends.client.model.FriendModel;
import com.mrbysco.distantfriends.client.state.DistantFriendRenderState;
import com.mrbysco.distantfriends.entity.DistantFriend;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FriendRenderer
extends HumanoidMobRenderer<DistantFriend, DistantFriendRenderState, FriendModel> {
    public static final PlayerSkin defaultSkin = DefaultPlayerSkin.getDefaultSkin();
    private final FriendModel playerModel;
    private final FriendModel slimPlayerModel;
    public static boolean isSlim = false;

    public FriendRenderer(EntityRendererProvider.Context context) {
        this(context, false);
    }

    public FriendRenderer(EntityRendererProvider.Context context, boolean slim) {
        super(context, (HumanoidModel)new FriendModel(context.bakeLayer(ModelLayers.PLAYER), slim), 0.0f);
        this.playerModel = new FriendModel(context.bakeLayer(ModelLayers.PLAYER), false);
        this.slimPlayerModel = new FriendModel(context.bakeLayer(ModelLayers.PLAYER_SLIM), true);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), context.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new WingsLayer((RenderLayerParent)this, context.getModelSet(), context.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet()));
    }

    public DistantFriendRenderState createRenderState() {
        return new DistantFriendRenderState();
    }

    public void extractRenderState(DistantFriend friend, DistantFriendRenderState renderState, float partialTick) {
        super.extractRenderState((Mob)friend, (HumanoidRenderState)renderState, partialTick);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)friend, (HumanoidRenderState)renderState, (float)partialTick, (ItemModelResolver)this.itemModelResolver);
        renderState.leftArmPose = FriendRenderer.getFriendArmPose(friend, HumanoidArm.LEFT);
        renderState.rightArmPose = FriendRenderer.getFriendArmPose(friend, HumanoidArm.RIGHT);
        renderState.swinging = friend.swinging;
        renderState.isSpectator = friend.isSpectator();
        renderState.skin = this.getSkin(friend.getProfile().orElse(null));
        renderState.id = friend.getId();
        renderState.name = friend.getProfile().isPresent() ? friend.getProfile().get().gameProfile().getName() : "unknown";
    }

    public void render(DistantFriendRenderState statueRenderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        isSlim = statueRenderState.skin != null && statueRenderState.skin.model() == PlayerSkin.Model.SLIM;
        this.model = isSlim ? this.slimPlayerModel : this.playerModel;
        super.render((LivingEntityRenderState)statueRenderState, poseStack, bufferSource, packedLightIn);
    }

    protected void scale(DistantFriendRenderState renderState, PoseStack poseStack) {
        float f = 0.9375f;
        poseStack.scale(f, f, f);
    }

    public ResourceLocation getTextureLocation(DistantFriendRenderState renderState) {
        return renderState.skin.texture();
    }

    private PlayerSkin getSkin(@Nullable ResolvableProfile profile) {
        SkinManager skinmanager = Minecraft.getInstance().getSkinManager();
        if (profile != null) {
            return skinmanager.getInsecureSkin(profile.gameProfile());
        }
        return defaultSkin;
    }

    public Vec3 getRenderOffset(DistantFriendRenderState renderState) {
        Vec3 vec3 = super.getRenderOffset((EntityRenderState)renderState);
        return renderState.isCrouching ? vec3.add(0.0, (double)(renderState.scale * -2.0f) / 16.0, 0.0) : vec3;
    }

    private static HumanoidModel.ArmPose getFriendArmPose(DistantFriend player, HumanoidArm arm) {
        ItemStack itemstack = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack itemstack1 = player.getItemInHand(InteractionHand.OFF_HAND);
        HumanoidModel.ArmPose humanoidmodel$armpose = FriendRenderer.getFriendArmPose(player, itemstack, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose humanoidmodel$armpose1 = FriendRenderer.getFriendArmPose(player, itemstack1, InteractionHand.OFF_HAND);
        if (humanoidmodel$armpose.isTwoHanded()) {
            humanoidmodel$armpose1 = itemstack1.isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        return player.getMainArm() == arm ? humanoidmodel$armpose : humanoidmodel$armpose1;
    }

    @Deprecated
    private static HumanoidModel.ArmPose getFriendArmPose(DistantFriend friend, ItemStack stack, InteractionHand hand) {
        return FriendRenderer.getFriendArmPose(friend, stack, hand, null);
    }

    private static HumanoidModel.ArmPose getFriendArmPose(DistantFriend friend, ItemStack stack, InteractionHand hand, @Nullable HumanoidModel.ArmPose pose) {
        if (pose != null) {
            return pose;
        }
        if (stack.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (friend.getUsedItemHand() == hand && friend.getUseItemRemainingTicks() > 0) {
            ItemUseAnimation itemuseanimation = stack.getUseAnimation();
            if (itemuseanimation == ItemUseAnimation.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (itemuseanimation == ItemUseAnimation.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (itemuseanimation == ItemUseAnimation.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (itemuseanimation == ItemUseAnimation.CROSSBOW) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (itemuseanimation == ItemUseAnimation.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (itemuseanimation == ItemUseAnimation.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if (itemuseanimation == ItemUseAnimation.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!friend.swinging && stack.is(Items.CROSSBOW) && CrossbowItem.isCharged((ItemStack)stack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }
}

