/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends;

import com.mrbysco.distantfriends.Constants;
import com.mrbysco.distantfriends.PlayerData;
import com.mrbysco.distantfriends.platform.Services;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_3337;

public class FriendNamesCache {
    public static final List<PlayerData> nameList = new ArrayList<PlayerData>();

    public static void refreshCache() {
        Constants.LOGGER.info("Refreshing friends cache");
        nameList.clear();
        nameList.addAll(FriendNamesCache.generateDataList());
        if (Services.PLATFORM.addWhitelistPlayers() && Services.PLATFORM.getServer() != null) {
            class_3337 whitelist = Services.PLATFORM.getServer().method_3760().method_14590();
            Arrays.stream(whitelist.method_14636()).map(PlayerData::new).forEach(nameList::add);
        }
        if (Services.PLATFORM.playerMobsCompat()) {
            List<? extends String> links = Services.PLATFORM.getPlayerMobsNameLinks();
            for (String string : links) {
                try {
                    URL url = new URL(string);
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            nameList.add(new PlayerData(line));
                        }
                    }
                }
                catch (IOException e) {
                    Constants.LOGGER.error(String.format("Error fetching names from %s", string), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<PlayerData> generateDataList() {
        ArrayList<PlayerData> dataList = new ArrayList<PlayerData>();
        ArrayList<? extends String> names = new ArrayList<String>(Services.PLATFORM.getFriends());
        for (String string : names) {
            void var3_3;
            if (string.isEmpty()) continue;
            String[] parts = string.split(",");
            String texture = null;
            if (parts.length > 1) {
                texture = parts[1].trim();
                String string2 = parts[0].trim();
                if (!texture.matches("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$")) {
                    Constants.LOGGER.error("Malformed base64 texture for friend: {}, {}", (Object)string2, (Object)texture);
                    Constants.LOGGER.error("If you inserted this base64 from the config screen the base64 was likely cut off due to the text limitations of the text field.");
                    texture = null;
                }
            }
            dataList.add(new PlayerData(var3_3.toLowerCase(Locale.ROOT), texture));
        }
        return dataList;
    }
}

