/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.DynamicOps;
import com.mrbysco.distantfriends.Constants;
import com.mrbysco.distantfriends.FriendNamesCache;
import com.mrbysco.distantfriends.PlayerData;
import com.mrbysco.distantfriends.entity.goal.LookedAtGoal;
import com.mrbysco.distantfriends.platform.Services;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1394;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2631;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_9296;
import org.jetbrains.annotations.Nullable;

public class DistantFriend
extends class_1314 {
    private static final class_2940<Optional<class_9296>> RESOLVABLE_PROFILE = class_2945.method_12791(DistantFriend.class, Services.PLATFORM.getResolvableProfileSerializer());
    private static final class_2940<Boolean> DATA_IN_VIEW = class_2945.method_12791(DistantFriend.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_LOOKED_AT = class_2945.method_12791(DistantFriend.class, (class_2941)class_2943.field_13323);
    private final class_2371<class_1799> handItems = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private final class_2371<class_1799> armorItems = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private final class_4051 findPlayerCondition = class_4051.method_36626().method_18418(16.0);

    public DistantFriend(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RESOLVABLE_PROFILE, Optional.empty());
        builder.method_56912(DATA_IN_VIEW, (Object)false);
        builder.method_56912(DATA_LOOKED_AT, (Object)false);
    }

    public Optional<class_9296> getProfile() {
        return (Optional)this.field_6011.method_12789(RESOLVABLE_PROFILE);
    }

    public void setProfile(class_9296 profile) {
        this.field_6011.method_12778(RESOLVABLE_PROFILE, Optional.of(profile));
    }

    public boolean isLookedAt() {
        return (Boolean)this.field_6011.method_12789(DATA_LOOKED_AT);
    }

    public void setLookedAt(boolean lookedAt) {
        this.field_6011.method_12778(DATA_LOOKED_AT, (Object)lookedAt);
    }

    public boolean isInView() {
        return (Boolean)this.field_6011.method_12789(DATA_IN_VIEW);
    }

    public void setInView(boolean inView) {
        this.field_6011.method_12778(DATA_IN_VIEW, (Object)inView);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new LookedAtGoal(this));
        this.field_6201.method_6277(2, (class_1352)new class_1361((class_1308)this, class_1657.class, 128.0f, 0.75f, false));
        this.field_6201.method_6277(4, (class_1352)new class_1338((class_1314)this, class_1657.class, 32.0f, 1.0, 1.33, class_1301.field_6155::test));
        this.field_6201.method_6277(6, (class_1352)new StrollWhenOutOfSight(this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, (double)0.23f).method_26868(class_5134.field_23721, 3.0);
    }

    public Iterable<class_1799> method_5877() {
        return this.handItems;
    }

    public Iterable<class_1799> method_5661() {
        return this.armorItems;
    }

    public class_1799 method_6118(class_1304 slotIn) {
        return switch (slotIn.method_5925()) {
            case class_1304.class_1305.field_6177 -> (class_1799)this.handItems.get(slotIn.method_5927());
            case class_1304.class_1305.field_6178 -> (class_1799)this.armorItems.get(slotIn.method_5927());
            default -> class_1799.field_8037;
        };
    }

    public void method_5673(class_1304 equipmentSlot, class_1799 stack) {
        this.method_37410(stack);
        switch (equipmentSlot.method_5925()) {
            case field_6177: {
                this.method_6116(equipmentSlot, (class_1799)this.handItems.set(equipmentSlot.method_5927(), (Object)stack), stack);
                break;
            }
            case field_6178: {
                this.method_6116(equipmentSlot, (class_1799)this.armorItems.set(equipmentSlot.method_5927(), (Object)stack), stack);
            }
        }
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public boolean method_5756(class_1657 player) {
        if (player.method_6057((class_1297)this) && this.field_6012 < 100) {
            return true;
        }
        return super.method_5756(player);
    }

    public boolean method_5643(class_1282 source, float amount) {
        this.method_31472();
        return super.method_5643(source, amount);
    }

    public void method_6007() {
        this.method_6119();
        if (this.field_6012 > 80 && this.field_6012 % 20 == 0 && !this.method_37908().method_18464(this.findPlayerCondition, (class_1309)this, this.method_5829().method_1009(16.0, 32.0, 16.0)).isEmpty()) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_5974.method_43059() * 0.02;
                double d1 = this.field_5974.method_43059() * 0.02;
                double d2 = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11203, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), d0, d1, d2);
            }
            this.method_31472();
        }
        super.method_6007();
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("inView", this.isInView());
        tag.method_10556("lookedAt", this.isLookedAt());
        tag.method_10556("profileExists", ((Optional)this.field_6011.method_12789(RESOLVABLE_PROFILE)).isPresent());
        if (this.getProfile().isPresent()) {
            tag.method_10566("profile", (class_2520)class_9296.field_49359.encodeStart((DynamicOps)class_2509.field_11560, (Object)((class_9296)((Optional)this.field_6011.method_12789(RESOLVABLE_PROFILE)).get())).getOrThrow());
        }
    }

    public void method_5651(class_2487 compound) {
        super.method_5651(compound);
        this.setInView(compound.method_10577("inView"));
        this.setLookedAt(compound.method_10577("lookedAt"));
        boolean profileExists = compound.method_10577("profileExists");
        if (profileExists) {
            this.field_6011.method_12778(RESOLVABLE_PROFILE, (Object)class_9296.field_49359.parse((DynamicOps)class_2509.field_11560, (Object)compound.method_10580("profile")).resultOrPartial(error -> Constants.LOGGER.error("Failed to load profile from Distant Friend: {}", error)));
        } else {
            this.field_6011.method_12778(RESOLVABLE_PROFILE, Optional.empty());
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficultyIn, class_3730 reason, @Nullable class_1315 spawnDataIn) {
        spawnDataIn = super.method_5943(level, difficultyIn, reason, spawnDataIn);
        List<PlayerData> friends = FriendNamesCache.nameList;
        if (!friends.isEmpty()) {
            PlayerData data = friends.get(this.field_5974.method_43048(friends.size()));
            String name = data.name();
            class_2631.method_52580((String)name).thenAccept(profile -> {
                GameProfile usedProfile = profile.orElse(new GameProfile(class_156.field_25140, name));
                class_9296 resolvableProfile = new class_9296(usedProfile);
                PropertyMap properties = resolvableProfile.comp_2412();
                if (data.texture() != null) {
                    properties.clear();
                    properties.put((Object)"textures", (Object)new Property("textures", data.texture()));
                }
                this.setProfile(resolvableProfile);
                this.method_5665((class_2561)class_2561.method_43470((String)name));
            });
        }
        return spawnDataIn;
    }

    public boolean isLookingAtMe(class_1657 player) {
        class_243 vec3 = player.method_5828(1.0f).method_1029();
        class_243 offsetVec = new class_243(this.method_23317() - player.method_23317(), this.method_23320() - player.method_23320(), this.method_23321() - player.method_23321());
        double d0 = offsetVec.method_1033();
        double d1 = vec3.method_1026(offsetVec = offsetVec.method_1029());
        return d1 > 1.0 - 0.025 / d0 && player.method_6057((class_1297)this);
    }

    public static boolean checkFriendSpawn(class_1299<? extends DistantFriend> entityType, class_5425 levelAccessor, class_3730 spawnType, class_2338 pos, class_5819 random) {
        return levelAccessor.method_8407() != class_1267.field_5801 && DistantFriend.isDarkEnoughToSpawn(levelAccessor, pos, random) && DistantFriend.method_20636(entityType, (class_1936)levelAccessor, (class_3730)spawnType, (class_2338)pos, (class_5819)random);
    }

    public static boolean isDarkEnoughToSpawn(class_5425 levelAccessor, class_2338 pos, class_5819 random) {
        if (levelAccessor.method_8314(class_1944.field_9284, pos) > random.method_43048(32)) {
            return false;
        }
        if (levelAccessor.method_8314(class_1944.field_9282, pos) > 0) {
            return false;
        }
        int i = levelAccessor.method_8410().method_8546() ? levelAccessor.method_22346(pos, 10) : levelAccessor.method_22339(pos);
        return i <= random.method_43048(8);
    }

    static class StrollWhenOutOfSight
    extends class_1394 {
        private final DistantFriend friend;

        public StrollWhenOutOfSight(DistantFriend friend) {
            super((class_1314)friend, 1.0);
            this.friend = friend;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.friend.isInView();
        }
    }
}

