/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import com.mrbysco.distantfriends.CommonClass;
import com.mrbysco.distantfriends.Constants;
import com.mrbysco.distantfriends.commands.DistantCommands;
import com.mrbysco.distantfriends.config.FriendConfigFabric;
import com.mrbysco.distantfriends.util.FriendNamesCache;
import com.mrbysco.distantfriends.util.ServerInstance;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_11891;
import net.minecraft.class_1269;
import net.minecraft.class_2168;
import net.minecraft.class_2960;

public class DistantFriendsFabric
implements ModInitializer {
    public static ConfigHolder<FriendConfigFabric> config;
    public static final AttachmentType<Boolean> IS_FRIEND;

    public void onInitialize() {
        config = AutoConfig.register(FriendConfigFabric.class, Toml4jConfigSerializer::new);
        config.registerLoadListener((manager, data) -> {
            FriendNamesCache.refreshCache();
            return class_1269.field_5812;
        });
        config.registerSaveListener((manager, data) -> {
            FriendNamesCache.refreshCache();
            return class_1269.field_5812;
        });
        AttackEntityCallback.EVENT.register((player, level, hand, entity, hitResult) -> {
            class_11891 mannequin;
            if (entity instanceof class_11891 && (mannequin = (class_11891)entity).hasAttached(IS_FRIEND)) {
                CommonClass.onFriendDamage(mannequin);
            }
            return class_1269.field_5811;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, context, selection) -> DistantCommands.initializeCommands((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            ServerInstance.setServer(server);
            FriendNamesCache.refreshCache();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> ServerInstance.setServer(null));
    }

    static {
        IS_FRIEND = AttachmentRegistry.createPersistent((class_2960)Constants.modLoc("is_friend"), (Codec)Codec.BOOL);
    }
}

