/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.config;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="distantfriends")
public class FriendConfigFabric
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public General general = new General();
    @ConfigEntry.Gui.CollapsibleObject
    public Compat compat = new Compat();
    @ConfigEntry.Gui.CollapsibleObject
    public Spawning spawning = new Spawning();

    public void validatePostLoad() throws ConfigData.ValidationException {
        if (this.spawning.spawnWeight <= 0) {
            this.spawning.spawnWeight = 20;
            throw new ConfigData.ValidationException("Spawn weight must be above 0 for distant friends. Resetting to default (20).");
        }
        if (!this.compat.playerMobsWhitelist.isEmpty()) {
            for (String link : this.compat.playerMobsWhitelist) {
                if (link.startsWith("https://whitelist.gorymoon.se")) continue;
                throw new ConfigData.ValidationException("The link " + link + " is not a valid link. Please use a link from https://whitelist.gorymoon.se");
            }
        }
    }

    public static class General {
        @Comment(value="A list of users who can be chosen when it spawns a distant friend.\nFormat: \"<username>\", \"<username>,<texture_location/body_type>\" or \"<username>,<texture_location/body_type>,<body_type>\"\nExample: \"darkosto\" or \"darkosto,minecraft:entity/player/slim/noor,slim\"")
        public List<String> friends = List.of("Darkosto", "ShyNieke", "Mrbysco");
        @Comment(value="A list of dimensions where distant friends can spawn, using their resource location. \nFormat: \"<namespace>:<path>\"\nExample: \"minecraft:overworld\" or \"minecraft:the_nether\"")
        public List<String> spawnDimensions = List.of("minecraft:overworld");
        @Comment(value="Add the players from the whitelist to the Friends list [default: true]")
        public boolean addWhitelistPlayers = true;
        @Comment(value="Show the name of the friend above their head [default: true]")
        public boolean showName = true;
    }

    public static class Compat {
        @Comment(value="Add players from a Player Mobs whitelist to the Friends list [default: false]")
        public boolean playerMobsCompat = false;
        @Comment(value="The player mobs Name Links")
        public List<String> playerMobsWhitelist = new ArrayList<String>();
    }

    public static class Spawning {
        @Comment(value="The spawn weight of the distant friend (Must be above 0) (Requires a restart) [default: 20]")
        public int spawnWeight = 20;
    }
}

