/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.util;

import com.mrbysco.distantfriends.Constants;
import com.mrbysco.distantfriends.platform.Services;
import com.mrbysco.distantfriends.util.PlayerData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3337;
import net.minecraft.class_7920;

public class FriendNamesCache {
    public static final List<PlayerData> nameList = new ArrayList<PlayerData>();

    public static void refreshCache() {
        Constants.LOGGER.info("Refreshing friends cache");
        nameList.clear();
        nameList.addAll(FriendNamesCache.generateDataList());
        if (Services.PLATFORM.addWhitelistPlayers() && Services.PLATFORM.getServer() != null) {
            class_3337 whitelist = Services.PLATFORM.getServer().method_3760().method_14590();
            Arrays.stream(whitelist.method_14636()).map(PlayerData::new).forEach(nameList::add);
        }
        if (Services.PLATFORM.playerMobsCompat()) {
            List<? extends String> links = Services.PLATFORM.getPlayerMobsNameLinks();
            for (String string : links) {
                try {
                    URL url = new URL(string);
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            nameList.add(new PlayerData(line));
                        }
                    }
                }
                catch (IOException e) {
                    Constants.LOGGER.error("Error fetching names from {}", (Object)string, (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<PlayerData> generateDataList() {
        ArrayList<PlayerData> dataList = new ArrayList<PlayerData>();
        ArrayList<? extends String> names = new ArrayList<String>(Services.PLATFORM.getFriends());
        for (String string : names) {
            void var3_3;
            if (string.isEmpty()) continue;
            String[] parts = string.split(",");
            String secondEntry = null;
            class_7920 bodyType = null;
            if (parts.length > 1) {
                String string2 = parts[0].trim();
                secondEntry = parts[1].trim();
                if (secondEntry.equals("slim") || secondEntry.equals("wide")) {
                    bodyType = secondEntry.equals("slim") ? class_7920.field_41122 : class_7920.field_41123;
                    secondEntry = "";
                } else if (parts.length > 2) {
                    String type = parts[2].trim().toLowerCase();
                    if (type.equals("slim")) {
                        bodyType = class_7920.field_41122;
                    } else if (type.equals("wide")) {
                        bodyType = class_7920.field_41123;
                    }
                }
                if (!secondEntry.isEmpty() && class_2960.method_12829((String)secondEntry) == null) {
                    Constants.LOGGER.error("Malformed ResourceLocation for friend: {}, {}", (Object)string2, (Object)secondEntry);
                    secondEntry = null;
                }
            }
            dataList.add(new PlayerData((String)var3_3, secondEntry, bodyType));
        }
        return dataList;
    }
}

