/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends;

import com.mojang.datafixers.util.Either;
import com.mrbysco.distantfriends.platform.Services;
import com.mrbysco.distantfriends.util.FriendNamesCache;
import com.mrbysco.distantfriends.util.PlayerData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.ClientAsset;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.UniquelyIdentifyable;

public class CommonClass {
    private static final List<Item> VALID_ITEMS = List.of(Items.WOODEN_SWORD, Items.STONE_SWORD, Items.IRON_SWORD, Items.GOLDEN_SWORD, Items.DIAMOND_SWORD, Items.NETHERITE_SWORD, Items.WOODEN_SHOVEL, Items.STONE_SHOVEL, Items.IRON_SHOVEL, Items.GOLDEN_SHOVEL, Items.DIAMOND_SHOVEL, Items.NETHERITE_SHOVEL, Items.WOODEN_PICKAXE, Items.STONE_PICKAXE, Items.IRON_PICKAXE, Items.GOLDEN_PICKAXE, Items.DIAMOND_PICKAXE, Items.NETHERITE_PICKAXE, Items.WOODEN_AXE, Items.STONE_AXE, Items.IRON_AXE, Items.GOLDEN_AXE, Items.DIAMOND_AXE, Items.NETHERITE_AXE, Items.WOODEN_HOE, Items.STONE_HOE, Items.IRON_HOE, Items.GOLDEN_HOE, Items.DIAMOND_HOE, Items.NETHERITE_HOE, Items.BOW, Items.CROSSBOW, Items.SHIELD, Items.STICK);
    private static final TargetingConditions findPlayerCondition = TargetingConditions.forNonCombat().range(10.0);
    private static final TargetingConditions watchTargeting = TargetingConditions.forNonCombat().range(256.0);
    private static final Map<EntityReference<Mannequin>, List<Item>> friendItemMap = new HashMap<EntityReference<Mannequin>, List<Item>>();
    private static final Map<EntityReference<Mannequin>, Integer> crouchIntervalMap = new HashMap<EntityReference<Mannequin>, Integer>();
    private static final Map<EntityReference<Mannequin>, Integer> punchIntervalMap = new HashMap<EntityReference<Mannequin>, Integer>();

    public static void onFriendTick(Mannequin friend) {
        Level level = friend.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (friend.isAlive()) {
                Player player;
                if (friend.tickCount > 80 && friend.tickCount % 20 == 0) {
                    boolean playerNearby;
                    boolean bl = playerNearby = !serverLevel.getNearbyPlayers(findPlayerCondition, (LivingEntity)friend, friend.getBoundingBox().inflate(16.0, 32.0, 16.0)).isEmpty();
                    if (playerNearby) {
                        serverLevel.broadcastEntityEvent((Entity)friend, (byte)60);
                        friend.discard();
                    }
                }
                if ((player = serverLevel.getNearestPlayer(watchTargeting, (LivingEntity)friend)) != null) {
                    EntityReference friendRef = EntityReference.of((UniquelyIdentifyable)friend);
                    boolean lookingAtMe = friend.isLookingAtMe((LivingEntity)player, 0.025, true, false, new double[]{friend.getEyeY()});
                    if (lookingAtMe) {
                        RandomSource random = friend.getRandom();
                        friend.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
                        if (friend.tickCount % crouchIntervalMap.getOrDefault(friendRef, 10) == 0) {
                            crouchIntervalMap.put((EntityReference<Mannequin>)friendRef, random.nextInt(50) + 10);
                            if (random.nextBoolean()) {
                                Pose pose = friend.getPose();
                                pose = pose == Pose.STANDING ? Pose.CROUCHING : Pose.STANDING;
                                friend.setPose(pose);
                            }
                        }
                        if (friend.tickCount % punchIntervalMap.getOrDefault(friendRef, 8) == 0) {
                            punchIntervalMap.put((EntityReference<Mannequin>)friendRef, random.nextInt(45) + 10);
                            if (random.nextBoolean()) {
                                if (!friendItemMap.containsKey(friendRef)) {
                                    ArrayList<Item> copyList = new ArrayList<Item>(VALID_ITEMS);
                                    Collections.shuffle(copyList);
                                    List items = copyList.subList(0, 4);
                                    friendItemMap.put((EntityReference<Mannequin>)friendRef, items);
                                }
                                List<Item> items = friendItemMap.get(friendRef);
                                ItemStack stack = friend.getMainHandItem();
                                if (!stack.isEmpty()) {
                                    friend.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                                } else {
                                    Item item = items.get(random.nextInt(items.size()));
                                    friend.setItemInHand(InteractionHand.MAIN_HAND, item.getDefaultInstance());
                                }
                            }
                        }
                    } else if (friend.getPose() != Pose.STANDING) {
                        friend.setPose(Pose.STANDING);
                    }
                }
            }
        }
    }

    public static void onFriendDamage(Mannequin friend) {
        Level level = friend.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.broadcastEntityEvent((Entity)friend, (byte)60);
            friend.discard();
        }
    }

    public static void attachSkin(Mannequin friend) {
        List<PlayerData> friends = FriendNamesCache.nameList;
        if (!friends.isEmpty()) {
            ResourceLocation location;
            PlayerData data = friends.get(friend.getRandom().nextInt(friends.size()));
            String name = data.name();
            String texture = data.texture();
            if (Services.PLATFORM.showName()) {
                friend.setCustomName((Component)Component.literal((String)name));
                friend.setCustomNameVisible(true);
            }
            Optional<Object> skin = Optional.empty();
            if (texture != null && !texture.isEmpty() && (location = ResourceLocation.tryParse((String)texture)) != null) {
                skin = Optional.of(new ClientAsset.ResourceTexture(location));
            }
            Optional<Object> bodyType = Optional.empty();
            if (data.bodyType() != null) {
                bodyType = Optional.of(data.bodyType());
            }
            PlayerSkin.Patch patch = PlayerSkin.Patch.EMPTY;
            if (skin.isPresent() || bodyType.isPresent()) {
                patch = PlayerSkin.Patch.create(skin, Optional.empty(), Optional.empty(), bodyType);
            }
            friend.setProfile((ResolvableProfile)new ResolvableProfile.Dynamic(Either.left((Object)name), patch));
            friend.setHideDescription(true);
        }
    }
}

